"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncSubject = void 0;
const Subject_js_1 = require("./Subject.js");
class AsyncSubject extends Subject_js_1.Subject {
    _value = null;
    _hasValue = false;
    _isComplete = false;
    _checkFinalizedStatuses(subscriber) {
        const { hasError, _hasValue, _value, thrownError, _closed, _isComplete } = this;
        if (hasError) {
            subscriber.error(thrownError);
        }
        else if (_closed || _isComplete) {
            _hasValue && subscriber.next(_value);
            subscriber.complete();
        }
    }
    next(value) {
        if (!this._closed) {
            this._value = value;
            this._hasValue = true;
        }
    }
    complete() {
        const { _hasValue, _value, _isComplete } = this;
        if (!_isComplete) {
            this._isComplete = true;
            _hasValue && super.next(_value);
            super.complete();
        }
    }
}
exports.AsyncSubject = AsyncSubject;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js.map