"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultIfEmpty = void 0;
const Observable_js_1 = require("../Observable.js");
function defaultIfEmpty(defaultValue) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}
exports.defaultIfEmpty = defaultIfEmpty;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/operators/defaultIfEmpty.js.map