"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipLast = void 0;
const identity_js_1 = require("../util/identity.js");
const Observable_js_1 = require("../Observable.js");
function skipLast(skipCount) {
    return skipCount <= 0
        ?
            identity_js_1.identity
        : (source) => new Observable_js_1.Observable((destination) => {
            let ring = new Array(skipCount);
            let seen = 0;
            source.subscribe((0, Observable_js_1.operate)({
                destination,
                next: (value) => {
                    const valueIndex = seen++;
                    if (valueIndex < skipCount) {
                        ring[valueIndex] = value;
                    }
                    else {
                        const index = valueIndex % skipCount;
                        const oldValue = ring[index];
                        ring[index] = value;
                        destination.next(oldValue);
                    }
                },
            }));
            return () => {
                ring = null;
            };
        });
}
exports.skipLast = skipLast;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/cjs/internal/operators/skipLast.js.map