import { operate, Observable, from } from '../Observable.js';
export function audit(durationSelector) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        let durationSubscriber = null;
        let isComplete = false;
        const endDuration = () => {
            durationSubscriber?.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                destination.next(value);
            }
            isComplete && destination.complete();
        };
        const cleanupDuration = () => {
            durationSubscriber = null;
            isComplete && destination.complete();
        };
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
                if (!durationSubscriber) {
                    from(durationSelector(value)).subscribe((durationSubscriber = operate({
                        destination,
                        next: endDuration,
                        complete: cleanupDuration,
                    })));
                }
            },
            complete: () => {
                isComplete = true;
                (!hasValue || !durationSubscriber || durationSubscriber.closed) && destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/operators/audit.js.map