import { Observable, operate, from } from '../Observable.js';
export function catchError(selector) {
    return (source) => new Observable((destination) => {
        let innerSub = null;
        let syncUnsub = false;
        let handledResult;
        innerSub = source.subscribe(operate({
            destination,
            error: (err) => {
                handledResult = from(selector(err, catchError(selector)(source)));
                if (innerSub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    handledResult.subscribe(destination);
                }
                else {
                    syncUnsub = true;
                }
            },
        }));
        if (syncUnsub) {
            innerSub.unsubscribe();
            innerSub = null;
            handledResult.subscribe(destination);
        }
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/operators/catchError.js.map