import { Observable, operate, COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../Observable.js';
export function materialize() {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => {
                destination.next(nextNotification(value));
            },
            error: (error) => {
                destination.next(errorNotification(error));
                destination.complete();
            },
            complete: () => {
                destination.next(COMPLETE_NOTIFICATION);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/operators/materialize.js.map