import { switchMap } from './switchMap.js';
import { Observable, operate } from '../Observable.js';
export function switchScan(accumulator, seed) {
    return (source) => new Observable((destination) => {
        let state = seed;
        switchMap((value, index) => accumulator(state, value, index))(source).subscribe(operate({
            destination,
            next: (innerValue) => {
                state = innerValue;
                destination.next(innerValue);
            },
        }));
        return () => {
            state = null;
        };
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/2ca326e0d1ce10956aea33d54c0e2d8c13c58a30/node_modules/rxjs/dist/esm/internal/operators/switchScan.js.map