// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { throttlingRetryPolicyName as tspThrottlingRetryPolicyName, throttlingRetryPolicy as tspThrottlingRetryPolicy, } from "@typespec/ts-http-runtime/internal/policies";
/**
 * Name of the {@link throttlingRetryPolicy}
 */
export const throttlingRetryPolicyName = tspThrottlingRetryPolicyName;
/**
 * A policy that retries when the server sends a 429 response with a Retry-After header.
 *
 * To learn more, please refer to
 * https://learn.microsoft.com/azure/azure-resource-manager/resource-manager-request-limits,
 * https://learn.microsoft.com/azure/azure-subscription-service-limits and
 * https://learn.microsoft.com/azure/virtual-machines/troubleshooting/troubleshooting-throttling-errors
 *
 * @param options - Options that configure retry logic.
 */
export function throttlingRetryPolicy(options = {}) {
    return tspThrottlingRetryPolicy(options);
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/@azure/core-rest-pipeline/dist/browser/policies/throttlingRetryPolicy.js.map