Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

/**
 * Get a list of possible event messages from a Sentry event.
 */
function getPossibleEventMessages(event) {
  const possibleMessages = [];

  if (event.message) {
    possibleMessages.push(event.message);
  }

  try {
    // @ts-expect-error Try catching to save bundle size
    const lastException = event.exception.values[event.exception.values.length - 1];
    if (lastException?.value) {
      possibleMessages.push(lastException.value);
      if (lastException.type) {
        possibleMessages.push(`${lastException.type}: ${lastException.value}`);
      }
    }
  } catch {
    // ignore errors here
  }

  return possibleMessages;
}

exports.getPossibleEventMessages = getPossibleEventMessages;//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/@sentry/core/build/cjs/utils/eventUtils.js.map
