import { app } from 'electron';
import { SDK_VERSION } from './version.js';

const SDK_NAME = 'sentry.javascript.electron';
/** Gets SDK info */
function getSdkInfo(sendDefaultPii) {
    return {
        name: SDK_NAME,
        packages: [
            {
                name: 'npm:@sentry/electron',
                version: SDK_VERSION,
            },
        ],
        version: SDK_VERSION,
        settings: { infer_ip: sendDefaultPii ? 'auto' : 'never' },
    };
}
/** Gets the default release name */
function getDefaultReleaseName() {
    const app_name = app.name || app.getName();
    return `${app_name.replace(/\W/g, '-')}@${app.getVersion()}`;
}
/** Gets the default environment */
function getDefaultEnvironment() {
    return app.isPackaged ? 'production' : 'development';
}
/**
 * Gets the default event data by calling all event processors.
 */
async function getEventDefaults(client) {
    let event = { message: 'test' };
    const eventHint = {};
    for (const processor of client.getEventProcessors()) {
        if (event === null)
            break;
        event = await processor(event, eventHint);
    }
    delete event?.message;
    return event || {};
}

export { SDK_NAME, getDefaultEnvironment, getDefaultReleaseName, getEventDefaults, getSdkInfo };//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/@sentry/electron/esm/main/context.js.map
