import { defineIntegration, normalize } from '@sentry/core';
import { addScopeListener } from '../../common/scope.js';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup(client) {
            const ipc = getIPC(client);
            addScopeListener((merged, changed) => {
                ipc.sendScope(JSON.stringify(normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

export { scopeToMainIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/@sentry/electron/esm/renderer/integrations/scope-to-main.js.map
