"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncSubject = void 0;
const Subject_js_1 = require("./Subject.js");
class AsyncSubject extends Subject_js_1.Subject {
    _value = null;
    _hasValue = false;
    _isComplete = false;
    _checkFinalizedStatuses(subscriber) {
        const { hasError, _hasValue, _value, thrownError, _closed, _isComplete } = this;
        if (hasError) {
            subscriber.error(thrownError);
        }
        else if (_closed || _isComplete) {
            _hasValue && subscriber.next(_value);
            subscriber.complete();
        }
    }
    next(value) {
        if (!this._closed) {
            this._value = value;
            this._hasValue = true;
        }
    }
    complete() {
        const { _hasValue, _value, _isComplete } = this;
        if (!_isComplete) {
            this._isComplete = true;
            _hasValue && super.next(_value);
            super.complete();
        }
    }
}
exports.AsyncSubject = AsyncSubject;//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/rxjs/dist/cjs/internal/AsyncSubject.js.map