import { Observable, isFunction } from '../Observable.js';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs.js';
export function fromEventPattern(addHandler, removeHandler, resultSelector) {
    if (resultSelector) {
        return mapOneOrManyArgs(resultSelector)(fromEventPattern(addHandler, removeHandler));
    }
    return new Observable((subscriber) => {
        const handler = (...e) => subscriber.next(e.length === 1 ? e[0] : e);
        const retValue = addHandler(handler);
        return isFunction(removeHandler) ? () => removeHandler(handler, retValue) : undefined;
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/rxjs/dist/esm/internal/observable/fromEventPattern.js.map