import { Observable, from } from '../Observable.js';
import { Subject } from '../Subject.js';
import { fromSubscribable } from '../observable/fromSubscribable.js';
const DEFAULT_CONFIG = {
    connector: () => new Subject(),
};
export function connect(selector, config = DEFAULT_CONFIG) {
    const { connector } = config;
    return (source) => new Observable((subscriber) => {
        const subject = connector();
        from(selector(fromSubscribable(subject))).subscribe(subscriber);
        subscriber.add(source.subscribe(subject));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/rxjs/dist/esm/internal/operators/connect.js.map