import { operate } from '../Observable.js';
export function scanInternals(accumulator, seed, hasSeed, emitOnNext, emitBeforeComplete, source, destination) {
    let hasState = hasSeed;
    let state = seed;
    let index = 0;
    source.subscribe(operate({
        destination,
        next: (value) => {
            const i = index++;
            state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value);
            emitOnNext && destination.next(state);
        },
        complete: emitBeforeComplete
            ? () => {
                hasState && destination.next(state);
                destination.complete();
            }
            : undefined,
    }));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/rxjs/dist/esm/internal/operators/scanInternals.js.map