import { EmptyError } from '../util/EmptyError.js';
import { Observable, operate } from '../Observable.js';
export function throwIfEmpty(errorFactory = defaultErrorFactory) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => (hasValue ? destination.complete() : destination.error(errorFactory())),
        }));
    });
}
function defaultErrorFactory() {
    return new EmptyError();
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/rxjs/dist/esm/internal/operators/throwIfEmpty.js.map