"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.code = exports.name = exports.isName = exports.isCode = void 0;
const isCode = (c) => exports.name.has(c);
exports.isCode = isCode;
const isName = (c) => exports.code.has(c);
exports.isName = isName;
// map types from key to human-friendly name
exports.name = new Map([
    ['0', 'File'],
    // same as File
    ['', 'OldFile'],
    ['1', 'Link'],
    ['2', 'SymbolicLink'],
    // Devices and FIFOs aren't fully supported
    // they are parsed, but skipped when unpacking
    ['3', 'CharacterDevice'],
    ['4', 'BlockDevice'],
    ['5', 'Directory'],
    ['6', 'FIFO'],
    // same as File
    ['7', 'ContiguousFile'],
    // pax headers
    ['g', 'GlobalExtendedHeader'],
    ['x', 'ExtendedHeader'],
    // vendor-specific stuff
    // skip
    ['A', 'SolarisACL'],
    // like 5, but with data, which should be skipped
    ['D', 'GNUDumpDir'],
    // metadata only, skip
    ['I', 'Inode'],
    // data = link path of next file
    ['K', 'NextFileHasLongLinkpath'],
    // data = path of next file
    ['L', 'NextFileHasLongPath'],
    // skip
    ['M', 'ContinuationFile'],
    // like L
    ['N', 'OldGnuLongPath'],
    // skip
    ['S', 'SparseFile'],
    // skip
    ['V', 'TapeVolumeHeader'],
    // like x
    ['X', 'OldExtendedHeader'],
]);
// map the other direction
exports.code = new Map(Array.from(exports.name).map(kv => [kv[1], kv[0]]));//# sourceMappingURL=http://go/sourcemap/sourcemaps/8c95649f251a168cc4bb34c89531fae7db4bd990/node_modules/tar/dist/commonjs/types.js.map