const char *tvh_doc_root_before_begin[] = {
"### ",
LANGPREF N_("Before You Begin"),
"\n\n",
LANGPREF N_("There are some basic concepts that will make life much easier if you understand them from the outset."),
"\n\n#### ",
LANGPREF N_("Hardware/Software Fundamentals"),
"\n\n* ",
LANGPREF N_("A __tuner__ is the hardware (chipset) needed to interpret a digital television signal and extract from it the programme stream. The tuner hardware is also responsible for communicating with your satellite dish via the LNB in the case of DVB-S."),
"\n* ",
LANGPREF N_("__Network tuners__ are small (usually"),
" [",
LANGPREF N_("arm"),
"](https://en.wikipedia.org/wiki/ARM_architecture) ",
LANGPREF N_("based) computers that you connect to your network via Ethernet or Wifi, they often have a large number of tuners and are controlled via a web interface or software. Many work out-of-the-box with Tvheadend using SAT>IP or the HDHomeRun protocols."),
"\n* ",
LANGPREF N_("A __driver__ is the piece of software that your operating system uses to talk to the tuner. This can be built into the OS (e.g. 'supported since kernel X') or might be a separate piece of software that you need install, and maybe even compile, separately."),
"\n* ",
LANGPREF N_("__Firmware__ is a small piece of binary microcode that your system driver sends to the tuner upon initialisation. This is the cause of more problems than you'd imagine... if you find yourself in trouble, this is the first thing to check along with kernel support for your hardware."),
"\n\n#### ",
LANGPREF N_("Application/Tvheadend Fundamentals"),
"\n\n",
LANGPREF N_("The Tvheadend software then sets up a series of configuration elements, and the way in which these interact determines how a TV signal ends up in front of you. They all use what's known as a _many-to-many_ relationship, in that one configuration element can be related to multiple elements of the next type, and vice versa: one tuner has multiple networks, one network can exist on multiple tuners."),
" \n\n* ",
LANGPREF N_("The __network__ is the software definition of your carrier network. Broadly, it lays out what sort of network it is (such as DVB-T or DVB-S2), how it gets scanned, where the DVB-S satellite is in orbit, and similar. Networks are used by tuners so the hardware knows where to look for a signal."),
"\n* ",
LANGPREF N_("Networks then have __muxes__ . These are the carrier frequencies that exist on the old analogue channels that are used to transmit multiple digital signals rather than a single analogue one. These signals are multiplexed together, hence the name _mux_ ."),
"\n* ",
LANGPREF N_("Muxes then carry __services__ . These are the individual streams of data. They can be TV or radio programmes, they can provide data services such as digital teletext, or they can be used as part of the control code for catch-up IPTV services."),
"\n* ",
LANGPREF N_("And finally, services are mapped to __channels__ . These are what you and your client software think in terms of: _\"I'd like to watch BBC One now, please\"_ ."),
"\n\n#### ",
LANGPREF N_("Why The Complexity?"),
"\n\n",
LANGPREF N_("Simply, because 'BBC One' might exist in many different places... it might have regional variations on multiple frequencies (so different services on different muxes); it might exist on more than one source (perhaps on two different satellites); and it might thus be accessible through more than one piece of hardware (two satellite tuners, or one satellite and one terrestrial tuner)."),
"\n\n",
LANGPREF N_("When you select the channel you want to watch or record, Tvheadend can then map a path through all those variables to ask a particular tuner to go and get the signal for you."),
"\n\n",
LANGPREF N_("The following diagram explains the relationship between these components:"),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("Relationship Between Tuners, Neworks, Muxes, Services and Channels"),
"](static/img/doc/before_begin/schematic.png)\n",

NULL
};

const char *tvh_doc_root_cmdline_options[] = {
"### ",
LANGPREF N_("Command-line Options"),
"\n\n",
LANGPREF N_("Usage: `tvheadend [OPTIONS]`"),
"\n\n#### ",
LANGPREF N_("Generic options"),
"\n```no-highlight\n  -h, --help                  Show this page\n  -v, --version               Show version information\n```\n\n#### ",
LANGPREF N_("Service configuration"),
"\n```no-highlight\n  -c, --config                Alternate configuration path\n  -B, --nobackup              Don't backup configuration tree at upgrade\n  -f, --fork                  Fork and run as daemon\n  -u, --user                  Run as user\n  -g, --group                 Run as group\n  -p, --pid                   Alternate PID path\n  -C, --firstrun              If no user account exists then create one with\n                              no username and no password. Use with care as\n                              it will allow world-wide administrative access\n                              to your Tvheadend installation until you create or edit\n                              the access control from within the Tvheadend web interface.\n  -U, --dbus                  Enable DBus\n  -e, --dbus_session          DBus - use the session message bus instead of the system one\n  -a, --adapters              Only use specified DVB adapters (comma-separated, -1 = none)\n      --satip_bindaddr        Specify bind address for SAT>IP server\n      --satip_rtsp            SAT>IP RTSP port number for server\n                              (default: -1 = disable, 0 = webconfig, standard port is 554)\n      --nosatip               Disable SAT>IP client\n      --satip_xml             URL with the SAT>IP server XML location\n```\n\n#### ",
LANGPREF N_("Server connectivity"),
"\n```no-highlight\n  -6, --ipv6                  Listen on IPv6\n  -b, --bindaddr              Specify bind address\n      --http_port             Specify alternative http port\n      --http_root             Specify alternative http webroot\n      --htsp_port             Specify alternative htsp port\n      --htsp_port2            Specify extra htsp port\n      --useragent             Specify User-Agent header for the http client\n      --xspf                  Use XSPF playlist instead of M3U\n```\n\n#### ",
LANGPREF N_("Debug options"),
"\n```no-highlight\n  -d, --stderr                Enable debug on stderr\n  -n, --nostderr              Disable debug on stderr\n  -s, --syslog                Enable debug to syslog\n  -S, --nosyslog              Disable syslog (all messages)\n  -l, --logfile               Enable debug to file\n      --debug                 Enable debug subsystems\n      --trace                 Enable trace subsystems\n      --subsystems            List subsystems\n      --fileline              Add file and line numbers to debug\n      --threadid              Add the thread ID to debug\n      --uidebug               Enable web UI debug (non-minified JS)\n  -A, --abort                 Immediately abort\n  -D, --dump                  Enable coredumps for daemon\n      --noacl                 Disable all access control checks\n      --nobat                 Disable DVB bouquets\n  -j, --join                  Subscribe to a service permanently\n```\n\n#### ",
LANGPREF N_("Testing options"),
"\n```no-highlight\n      --tsfile_tuners         Number of tsfile tuners\n      --tsfile                tsfile input (mux file)\n```\n",

NULL
};

const char *tvh_doc_root_configure_tvheadend[] = {
"### ",
LANGPREF N_("Configure Tvheadend"),
"\n\n",
LANGPREF N_("This section gives a high-level overview of the steps needed to get Tvheadend up and running. For more detailed information, please consult the rest of this guide - much of it is arranged in the same order as the tabs on the Tvheadend interface so you know where to look."),
"\n\n",
LANGPREF N_("You can also consult the in-application help text, which mirrors this guide to a very great extent."),
"\n\n#### ",
LANGPREF N_("1. Ensure Tuners are Available for Use"),
"\n\n",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> TV Adapters_ __"),
" \n\n",
LANGPREF N_("On this tab, you'll see a tree structure, with the Linux device list at the top level (e.g. `/dev/dvb/adapter0`)"),
"\n\n",
LANGPREF N_("Individual tuners are then the next level down (e.g. `DiBcom 7000PC : DVB-T #0`)"),
"\n\n",
LANGPREF N_("Click on each tuner that you want Tvheadend to use, and ensure \"Enabled\" is checked in the 'Parameters' list"),
"\n\n",
LANGPREF N_("If anything is obviously wrong at this point, you probably have a driver/firmware error which you'll need to resolve before going any further."),
"\n\n#### ",
LANGPREF N_("2. Set up Relevant Network(s)"),
"\n\n",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> Networks_ __"),
" \n\n",
LANGPREF N_("Create a network of the appropriate type here. You can have multiple networks of the same type as necessary, e.g. to have two DVB-T networks defined, one with HD muxes, one without."),
"\n\n",
LANGPREF N_("The creation process allows you to select from a series of pre-defined mux lists for common DVB sources. These are available"),
" [",
LANGPREF N_("here"),
"](https://github.com/tvheadend/dtv-scan-tables) ",
LANGPREF N_("- but they do go out of date as broadcasters move services around and national authorities change entire pieces of spectrum. As such, you should try the pre-defined values, but you may need to add muxes manually."),
"\n\n* ",
LANGPREF N_("When creating a DVB-S network, be sure to set the orbital position of the satellite to which your dish is pointing, as some satellites provide additional information related to other nearby satellites that you may not be able to receive."),
"\n* ",
LANGPREF N_("Network discovery (enabled by default) increases the likelihood of receiving all available muxes and services."),
"\n\n#### ",
LANGPREF N_("3. Associate the Network with the Respective Tuner(s)"),
"\n\n",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> TV Adapters_ __"),
" \n\n",
LANGPREF N_("Associate each of your tuners with the correct network through _Parameters -> Basic Settings_ ."),
" \n\n",
LANGPREF N_("This can be as simple or as complex as necessary. You may simply have, for example, a single DVB-S2 network defined and then associate this with all DVB-S2 tuners. Or, you might have multiple networks defined - different satellites, different encoding. So, as further examples, you might define and then associate an HD DVB-T2 (e.g. H.264) network with HD tuners, while having a separate SD network associated with an independent SD (e.g. MPEG-2) tuner."),
" \n\n",
LANGPREF N_("At this point, your tuners now know what networks to use: one network can appear on multiple tuners (many-to-one), and one tuner can have multiple networks."),
"\n\n#### ",
LANGPREF N_("4. If Necessary, Manually Add Muxes"),
"\n\n",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> Muxes_ __"),
" \n\n",
LANGPREF N_("Ideally, this is where you'll see a list of the pre-populated muxes as created when you set up your initial network. However, should there be any issues, this is where you can manually add missing muxes. You only really need to worry about this if the pre-defined list didn't work (e.g. because of out-of-date data as broadcasters re-arrange their services or because automatic detection (network discovery) hasn't successfully found all the muxes over time."),
" \n\n",
LANGPREF N_("If you do need to add something manually, you'll need to search the Internet for details of the appropriate transmitter and settings: satellites tend not to change much and are universal over a large area, but terrestrial muxes are typically very localised and you'll need to know which specific transmitter you're listening to."),
" \n\n",
LANGPREF N_("__Note__ : Some tuners (or drivers) require more tuning parameters than others so __be sure to enter as many tuning parameters as possible__ ."),
"\n\n",
LANGPREF N_("Good sources of transmitter/mux information include:"),
"\n\n* [",
LANGPREF N_("KingofSat"),
"](http://en.kingofsat.net) ",
LANGPREF N_("for all European satellite information"),
"\n* [",
LANGPREF N_("ukfree.tv"),
"](http://www.ukfree.tv/maps/freeview) ",
LANGPREF N_("for UK DVB-T transmitters"),
"\n* [",
LANGPREF N_("Interactive EU DVB-T map"),
"](http://www.dvbtmap.eu/mapmux.html) ",
LANGPREF N_("for primarily central and northern Europe"),
"\n* [",
LANGPREF N_("Lyngsat"),
"](http://www.lyngsat.com/) ",
LANGPREF N_("for worldwide satellite information."),
"\n\n",
LANGPREF N_("You can also use"),
" [",
LANGPREF N_("dvbscan"),
"](http://www.linuxtv.org/wiki/index.php/Dvbscan) ",
LANGPREF N_("to force a scan and effectively ask your tuner what it can see."),
"\n\n#### ",
LANGPREF N_("5. Scan for Services"),
"\n\n",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> Services_ __"),
" \n\n",
LANGPREF N_("This is where the services will appear as your tuners tune to the muxes based on the network you told them to look on. Again, remember what's happening: Tvheadend is telling your tuner hardware (via the drivers) to sequentially tune to each mux it knows about, and then see what 'programs' it can see on that mux, each of which is identified by a series of unique identifiers that describe the audio stream(s), the video stream(s), the subtitle stream(s) and language(s), and so on."),
"\n\n",
LANGPREF N_("(For the technically-minded, these unique identifiers - the elementary streams - are referred to as 'packet identifiers' or 'PIDs')."),
"\n\n#### ",
LANGPREF N_("6. Map Services to Channels"),
"\n\n  ",
LANGPREF N_("__Tvheadend web interface: _Configuration -> DVB Inputs -> Services_ __"),
" \n\n  ",
LANGPREF N_("Once scanning for services is complete, you need to map the services to channels so your client can actually request them (i.e. so you can watch or record)."),
"\n\n  ",
LANGPREF N_("See"),
" [",
LANGPREF N_("Services"),
"](class/mpegts_service) ",
LANGPREF N_("for a detailed look into service mapping."),
"\n\n##### ",
LANGPREF N_("6.1. Bouquets"),
"\n\n  ",
LANGPREF N_("__Tvheadend web interface: _Configuration -> Channel / EPG -> Bouquets_ __"),
" \n\n  ",
LANGPREF N_("Many service providers use bouquets for channel management and just like a standard set-top box Tvheadend can use these to automatically manage and keep your channels up-to-date."),
"\n\n  ",
LANGPREF N_("If you would like to use bouquets see"),
" [",
LANGPREF N_("Bouquets"),
"](class/bouquet)",
LANGPREF N_("."),
"\n\n#### ",
LANGPREF N_("7. Watch TV"),
"\n\n",
LANGPREF N_("That's it - you're done. You should now have a working basic Tvheadend installation with channels mapped and ready for use!"),
"\n\n",
LANGPREF N_("As required, you may now wish to look into:"),
"\n\n* ",
LANGPREF N_("Setting up different EPGs (inc. localised character sets and timing offsets)"),
"\n* ",
LANGPREF N_("Setting up channel icons"),
"\n* ",
LANGPREF N_("Setting up recording profiles"),
"\n* ",
LANGPREF N_("Setting up streaming profiles (including transcoding)"),
"\n* ",
LANGPREF N_("Arranging your channels into groups (channel tags)"),
"\n* ",
LANGPREF N_("Setting up softcams for descrambling"),
"\n* ",
LANGPREF N_("Setting up access control rules for different client types/permission levels"),
"\n",

NULL
};

const char *tvh_doc_root_doc_about[] = {
"### ",
LANGPREF N_("About"),
"\n\n",
LANGPREF N_("This documentation forms part of the Tvheadend project."),
"\n\n",
LANGPREF N_("All rights reserved, and all implications of using, following, not following, or in any way even being aware of this documentation are expressly excluded. Use everything entirely at your own risk. If your television explodes, your house burns down or your kittens end up in tears, that's nothing to do with us."),
"\n\n",
LANGPREF N_("(c) 2006 - 2017 Tvheadend Foundation CIC"),
"\n\n### ",
LANGPREF N_("Licensing"),
"\n\n",
LANGPREF N_("The entire project is currently licensed using"),
" [",
LANGPREF N_("GPLv3"),
"](http://www.gnu.org/licenses/gpl-3.0.txt)",
LANGPREF N_("."),
"\n\n### ",
LANGPREF N_("Further Information"),
"\n\n",
LANGPREF N_("For more information regarding the project, licensing and contributions, please see:"),
"\n\n[",
LANGPREF N_("Project website"),
"](https://tvheadend.org)\n\n[",
LANGPREF N_("Contributor information"),
"](https://tvheadend.org/projects/tvheadend/wiki/Contributors)\n\n[",
LANGPREF N_("Contributor Licensing Agreement"),
"](https://tvheadend.org/projects/tvheadend/wiki/CLA)\n",

NULL
};

const char *tvh_doc_root_doc_update[] = {
"### ",
LANGPREF N_("Updating the Documentation"),
"\n\n",
LANGPREF N_("The documentation is written in markdown, and then converted for direct inclusion to tvheadend binary. The markdown processor in tvheadend binary adds other information from the internal class system."),
"\n\n",
LANGPREF N_("The User Guide in"),
" [",
LANGPREF N_("documentatation repository"),
"](https://github.com/tvheadend/tvheadend-documentation) ",
LANGPREF N_("fetches the markdown files using the build-in web server and use them as source for mkdocs."),
"\n\n#### ",
LANGPREF N_("Instructions For Built-in Help"),
"\n\n",
LANGPREF N_("Change markdown files in `docs/markdown`, `docs/markdown/inc`, `docs/class`, `docs/wizard`, etc. Images are placed in `src/webui/static/img/doc/`."),
"\n\n",
LANGPREF N_("Build Tvheadend as you normally would, see the"),
" [",
LANGPREF N_("development page"),
"](https://tvheadend.org/projects/tvheadend/wiki/Development) ",
LANGPREF N_("for details."),
"\n",

NULL
};

const char *tvh_doc_root_epg[] = {
"### ",
LANGPREF N_("Electronic Program Guide"),
"\n\n",
LANGPREF N_("Tvheadend has a built-in Electronic Program Guide. The EPG is an in-memory database populated with all the information about events received from the DVB networks over-the-air or from external grabbers such as XMLTV."),
"\n\n",
LANGPREF N_("The EPG tab displays a filterable grid containing all events, sorted based on start time."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Electronic Program Guide' Tab"),
"](static/img/doc/epg/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n##### ",
LANGPREF N_("Filtering (or searching)"),
"\n\n",
LANGPREF N_("In the EPG top tool bar you can access five input fields. These are used to filter/search for events. The form uses implicit AND between the input fields. This means that all filters must match for an event to be displayed."),
"\n\n",
LANGPREF N_("Filter"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Search title..."),
"__  | ",
LANGPREF N_("Only display events that match the given title."),
"\n | ",
LANGPREF N_("The filter uses case-insensitive regular expressions. If you don’t know what a regular expression is, this simply means that you can type just parts of the title and filter on that - there’s no need for full, exact matching. If the fulltext checkbox is checked, the title text is matched against title, subtitle, summary and description."),
"\n__",
LANGPREF N_("Filter channel..."),
"__  | ",
LANGPREF N_("Only display events from the selected channel."),
"\n | ",
LANGPREF N_("Channels in the drop down are ordered by name and can be filtered (by name) by typing in the box."),
"\n__",
LANGPREF N_("Filter tag..."),
"__  | ",
LANGPREF N_("Only display events from channels which are included in the selected tag."),
"\n | ",
LANGPREF N_("Tags are used for grouping channels together - such as ‘Radio’ or ‘HDTV’ - and are configured by the administrator. You can start typing a tag name to filter the list."),
"\n__",
LANGPREF N_("Filter content type..."),
"__  | ",
LANGPREF N_("Only display events that match the given content type tag."),
"\n | ",
LANGPREF N_("Most DVB networks classify their events into content groups. This field allows you to filter based on content type (e.g. “Sports” or “Game Show”). Supported tags are determined by your broadcaster. Again, simply start typing to filter the entries if you have a long list to choose from."),
"\n__",
LANGPREF N_("Filter duration..."),
"__  | ",
LANGPREF N_("Only display events that fall between the given minimum and maximum durations."),
"\n | ",
LANGPREF N_("This allows you to filter for or against, say, a daily broadcast and a weekly omnibus edition of a program, or only look for short news bulletins and not the 24-hour rolling broadcasts."),
"\n\n",
LANGPREF N_("_Title_ , _Channel_ , _Tag_ and _Content Type_ are dependent on your configuration and on what your broadcaster sends. Options for the _Duration_ are as follows:"),
"\n\n",
LANGPREF N_("Filter Range"),
" | ",
LANGPREF N_("Example Purpose"),
"\n----- | -----\n",
LANGPREF N_("00:00:01 to 00:15:00"),
" | ",
LANGPREF N_("Very short news bulletins, children's programs, etc."),
"\n",
LANGPREF N_("00:15:01 to 00:30:00"),
" | ",
LANGPREF N_("Short programs, e.g. daily soap operas"),
"\n",
LANGPREF N_("00:30:01 to 01:30:00"),
" | ",
LANGPREF N_("Medium-length programs, e.g. documentaries"),
"\n",
LANGPREF N_("01:30:01 to 03:00:00"),
" | ",
LANGPREF N_("Longer programs, e.g. films"),
"\n",
LANGPREF N_("03:00:00 to no maximum"),
" | ",
LANGPREF N_("Very long programs, e.g. major sporting events"),
"\n\n",
LANGPREF N_("So, if you only want to see Movies from your available HD channels, you would select ‘HDTV’ in the _[Filter tag…]_ field, and select ‘Movie / Drama’ in the _[Filter content type…]_ field. If you wish, you could then further limit the search to programs of between 90 minutes and 3 hours by selecting ‘01:30:01 to 03:00:00’ in the _[Filter duration…]_ field."),
"\n\n",
LANGPREF N_("Note that you don’t have to press a ‘Search’ button: the grid immediately updates itself as you change the filters."),
"\n\n",
LANGPREF N_("You can clear an individual filter by simply deleting its contents, or by selecting _‘(Clear filter)’_ as appropriate on all except the title filter. If you want to clear all filters, just press the _[Reset All]_ button."),
"\n\n##### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are also available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Reset All"),
"__  | ",
LANGPREF N_("Clears all search filters."),
"\n__",
LANGPREF N_("Watch TV"),
"__  | ",
LANGPREF N_("Launches Live TV via HTML5 video (see below)."),
"\n__",
LANGPREF N_("Create Autorec"),
"__  | ",
LANGPREF N_("Creates an auto-recording rule based on the current filter criteria (see below)."),
"\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Grid Items"),
"\n\n",
LANGPREF N_("The main grid items have the following functions:"),
"\n\n",
LANGPREF N_("__Details__ : Displays the current status of a recording event for this program if one applies:"),
" \n\n",
LANGPREF N_("Icon"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n![",
LANGPREF N_("Clock icon"),
"](icons/scheduled.png) | ",
LANGPREF N_("the program is scheduled for recording"),
"\n![",
LANGPREF N_("Recording icon"),
"](icons/rec.png) | ",
LANGPREF N_("the program is currently recording"),
"\n![",
LANGPREF N_("Broadcast details icon"),
"](icons/broadcast_details.png) | ",
LANGPREF N_("click to call up more detailed information about an event"),
"\n![",
LANGPREF N_("Exclamation icon"),
"](icons/exclamation.png) | ",
LANGPREF N_("the program failed to record"),
"\n\n",
LANGPREF N_("__Progress__ : A bar graph display of how far through a program we currently are."),
"\n\n",
LANGPREF N_("__Title__ : The title of the program. _You can automatically set a filter to the value of this field by clicking on it (e.g. click on 'Daily News' will automatically filter the whole grid to only show programs with the same name)._"),
" \n\n",
LANGPREF N_("__Subtitle__ : The subtitle of the program, if gien by your EPG provider. Note that some (notably, UK) providers use this for a program synopsis instead of a true subtitle."),
"\n\n",
LANGPREF N_("__Episode__ : Episode number, if given by your EPG provider."),
"\n\n",
LANGPREF N_("__Start Time__ : The scheduled start time of the program."),
"\n\n",
LANGPREF N_("__End Time__ : The scheduled end time of the program."),
"\n\n",
LANGPREF N_("__Duration__ : The scheduled duration (i.e. start time to end time) of the program."),
" \n\n",
LANGPREF N_("__Number__ : The channel number of the broadcasting channel, if defined."),
"\n\n",
LANGPREF N_("__Channel__ : The name of the broadcasting channel. _You can automatically set a filter to the value of this field by clicking on it (e.g. click on 'Channel 4 HD' will automatically filter the whole grid to only show programs from that channel)._"),
" \n\n",
LANGPREF N_("__Stars__ : Rating (in stars) of the program."),
"\n\n",
LANGPREF N_("__Age__ : Age rating of the program."),
"\n\n",
LANGPREF N_("__Content Type__ : Any content/genre information as provided by the EPG provider. _You can automatically set a filter to the value of this field by clicking on it (e.g. click on 'Movie/Drama' will automatically filter the whole grid to only show programs of the same type)._"),
" \n\n---\n\n#### ",
LANGPREF N_("Event Details and Recording"),
"\n\n",
LANGPREF N_("If you click on a single event, a popup will display detailed information about the event. It also allows you to schedule the event for recording by clicking on the _[Record program]_ button."),
"\n\n",
LANGPREF N_("For EPG providers that supply series link information there will also be a _[Record series]_ button that will record all entries in the series."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("EPG Detail 1"),
"](static/img/doc/epg/series_link.png)\n\n",
LANGPREF N_("For events without any series link information, an _[Autorec]_ button will be provided to create a pseudo-series link using the autorec feature."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("EPG Detail 2"),
"](static/img/doc/epg/autorec.png)\n\n",
LANGPREF N_("If you schedule any kind of recording from this point, you can choose a specific DVR profile that will apply to the recording or autorec rule. This will normally show as _(default)_ , but you can define different profiles in the __Configuration -> Recording ->"),
" [",
LANGPREF N_("Digital Video Recorder Profiles"),
"](class/dvrconfig)",
LANGPREF N_("__ tab. This allows you to set, for example, more post- broadcast padding for a channel that always runs late, or perhaps define a different post-processing command to strip adverts out on a commercial channel."),
"\n\n",
LANGPREF N_("You will also see _[Search IMDB]_ and _[TheTVDB]_ buttons to look for the program by name on imdb.com/thetvdb.com, and a _[Play program]_ button to watch a program that’s already in progress. This second button downloads a playlist file (XSPF or M3U depending on your startup options); if your system is configured for it, this will automatically launch an appropriate player, otherwise you will need to manually open the playlist to start watching (normally a double-click on the downloaded file)."),
"\n\n",
LANGPREF N_("To close the popup, just click on the [X] window button. The popup isn’t modal, so you don’t have to close it before doing something else, and you can open as many detailed information popups as you want."),
"\n\n---\n\n#### ",
LANGPREF N_("Autorecordings"),
"\n\n",
LANGPREF N_("Should you wish to record all events matching a specific query (to record your favourite show every week, for example) you can press the _[Create AutoRec]_ button in the top toolbar."),
"\n\n",
LANGPREF N_("You can change or delete the autorec rules in the __"),
"[",
LANGPREF N_("Autorec"),
"](class/dvrautorec)",
LANGPREF N_("__ tab. Use that editor if you temporarily want to disable an autorecording or make adjustments to the channel, tag, or similar."),
"\n\n---\n\n#### ",
LANGPREF N_("Watch TV"),
"\n\n",
LANGPREF N_("If you want to watch live TV in the web UI, the _[Watch TV]_ button will pop up a HTML5 video player, where you can select the channel to watch and a stream profile to use. A transcoding stream profile is required to transcode the stream to a format that is supported by your browser, as browsers only support certain formats and codecs."),
"\n\n##### ",
LANGPREF N_("Supported formats (containers)"),
"\n\n",
LANGPREF N_("Browser"),
" | ",
LANGPREF N_("MPEG-TS"),
" | ",
LANGPREF N_("MPEG-PS"),
" | ",
LANGPREF N_("Matroska"),
" | ",
LANGPREF N_("WebM"),
"\n:---: | :---: | :---: | :---: | :---:\n",
LANGPREF N_("Google Chrome"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n",
LANGPREF N_("Mozilla Firefox"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) |  | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n\n##### ",
LANGPREF N_("Supported video codecs"),
"\n\n",
LANGPREF N_("Browser"),
" | ",
LANGPREF N_("MPEG2 Video"),
" | ",
LANGPREF N_("H.264"),
" | ",
LANGPREF N_("VP8"),
"\n:---: | :---: | :---: | :---:\n",
LANGPREF N_("Google Chrome"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n",
LANGPREF N_("Mozilla Firefox"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) |  | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n\n##### ",
LANGPREF N_("Supported audio codecs"),
"\n\n",
LANGPREF N_("Browser"),
" | ",
LANGPREF N_("MPEG2 Audio"),
" | ",
LANGPREF N_("Dolby Digital (AC3)"),
" | ",
LANGPREF N_("AAC"),
" | ",
LANGPREF N_("Vorbis"),
"\n:---: | :---: | :---: | :---: | :---:\n",
LANGPREF N_("Google Chrome"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png) | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n",
LANGPREF N_("Mozilla Firefox"),
" | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) | ![",
LANGPREF N_("no"),
"](icons/exclamation.png) |  | ![",
LANGPREF N_("yes"),
"](icons/accept.png)\n",

NULL
};

const char *tvh_doc_root_faqs[] = {
"### ",
LANGPREF N_("FAQ: Frequently-asked Questions"),
"\n\n#### ",
LANGPREF N_("Q: How do I get a playlist for all my channels?"),
"\n\n",
LANGPREF N_("Tvheadend can generate a playlist of all your mapped services (channels). You can download it from the webui at `http://IP:Port/playlist`, e.g. `http://192.168.0.2:9981/playlist`."),
"\n\n#### ",
LANGPREF N_("Q: Why am I getting a playlist when trying to view/stream a channel?"),
"\n\n",
LANGPREF N_("By default Tvheadend's _Play_ links are playlists, although not all players accept them (e.g. Media Player Classic Home Cinema). You can bypass this by removing the `/play/` path from the url."),
"\n\n#### ",
LANGPREF N_("Q: Tvheadend has scanned for services but some rows in the Service Name column are blank, is that normal?"),
"\n\n",
LANGPREF N_("Yes, not all services are given a name by providers. These services are usually hidden for a reason and are often used for things such as encrypted guide data for set-top boxes, interactive services, and so on."),
"\n\n",
LANGPREF N_("If you're not seeing any service names at all this may indicate an issue with your hardware and/or configuration."),
"\n\n#### ",
LANGPREF N_("Q: I get a blank page when trying to view the web interface!"),
"\n\n",
LANGPREF N_("This usually happens when Tvheadend is installed incorrectly. As a start, make sure that the web interface path `/usr/share/tvheadend/src/webui/static/` exists and isn't empty."),
" \n\n",
LANGPREF N_("Note: The above path only applies to Debian/Ubuntu systems others may differ."),
"\n\n#### ",
LANGPREF N_("Q: Why can't I see my tuners in Tvheadend's interface?"),
"\n\n",
LANGPREF N_("This is normally because they're not installed properly. Check syslog/dmesg (e.g. `dmesg | grep dvb`) and see that you have startup messages that indicate whether or not the tuners have initialized properly. Similarly, check `/dev/dvb` to see if the block device files (i.e. the files used to communicate with the tuner) have been created correctly."),
"\n\n",
LANGPREF N_("The other major cause of this issue is when you're running Tvheadend as a user who doesn't have sufficient access to the tuners, such as not being a member of the _video_ group."),
"\n\n#### ",
LANGPREF N_("Q: Access Tvheadend through HTTP proxy"),
"\n\n",
LANGPREF N_("Use '--http_root' directive to specify the alternative http webroot (initial path prefix). The proxy server _MUST_ pass this webroot path in the HTTP request, otherwise an access to the Tvheadend server will end with the endless redirect loop."),
"\n\n",
LANGPREF N_("Example for nginx (--http_root=/my/tvh/server):"),
"\n```no-highlight\nlocation /my/tvh/server {\n  proxy_pass http://1.1.1.1:9981;\n  proxy_set_header Host $host;\n  proxy_set_header X-Real-IP $remote_addr;\n  proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n}\n```\n\n",
LANGPREF N_("Example for apache (--http_root=/my/tvh/server):"),
"\n```no-highlight\nProxyPass \"/my/tvh/server\" \"http://1.1.1.9981/my/tvh/server\";\n```\n",

NULL
};

const char *tvh_doc_root_features[] = {
"### ",
LANGPREF N_("Features of Tvheadend"),
"\n\n##### ",
LANGPREF N_("SDTV and HDTV support"),
"\n\n* ",
LANGPREF N_("H.265 (HEVC), H.264 (MPEG-4 AVC) and MPEG2 video supported."),
"\n* ",
LANGPREF N_("AC-3, AAC and MP2 audio supported."),
"\n* ",
LANGPREF N_("DVB subtitles supported."),
"\n* ",
LANGPREF N_("Teletext subtitles supported."),
"\n\n##### ",
LANGPREF N_("Input Sources"),
"\n\n* ",
LANGPREF N_("Satellite signals via DVB-S and DVB-S2"),
"\n* ",
LANGPREF N_("Terrestrial/Over-the-Air signals via DVB-T, DVB-T2 and ATSC"),
"\n* ",
LANGPREF N_("Cable signals via DVB-C"),
"\n* ",
LANGPREF N_("LAN/IPTV signals such as IPTV, SAT>IP, HDHomeRun"),
"\n* ",
LANGPREF N_("A general-purpose MPEG-TS `pipe://` for analogue and non-broadcast sources"),
"\n* ",
LANGPREF N_("Support for multiple adapters of any mix, with each adapter able to receive simultaneously all programmes on the current mux."),
"\n* ",
LANGPREF N_("Powerful many-to-many channel:service:tuner mapping that allows you to select channels irrespective of the underlying carrier (for channels that broadcast on multiple sources)."),
" \n\n##### ",
LANGPREF N_("Output Targets"),
"\n\n* ",
LANGPREF N_("Local or remote disk, via the built-in digital video recorder."),
"\n* ",
LANGPREF N_("HTSP (Home TV Streaming Protocol)."),
"\n* ",
LANGPREF N_("HTTP streaming."),
"\n* ",
LANGPREF N_("SAT>IP server (including on-the-fly descrambling)."),
"\n\n##### ",
LANGPREF N_("Transcoding Support"),
"\n\n* ",
LANGPREF N_("Subject to your system's capabilities, support for on-the-fly transcoding for both live and recorded streams in various formats."),
"\n\n##### ",
LANGPREF N_("Digital Video Recorder"),
"\n\n* ",
LANGPREF N_("Built in video recorder stores recorded programs as Transport Stream (.ts) or Matroska (.mkv) files."),
"\n* ",
LANGPREF N_("Multiple simultaneous recordings are supported."),
"\n* ",
LANGPREF N_("All original streams (multiple audio tracks, etc) are recorded."),
"\n* ",
LANGPREF N_("Streams can be selected and filtered positively or negatively as required."),
"\n* ",
LANGPREF N_("Create rule sets manually or based on EPG queries."),
"\n* ",
LANGPREF N_("Multiple DVR profiles that support different target directories, post-processing options, filtering options, etc."),
"\n\n##### ",
LANGPREF N_("Electronic Program Guide"),
"\n\n* ",
LANGPREF N_("Rich EPG support, with data from DVB/OTA, XMLTV (scheduled and socket)."),
"\n* ",
LANGPREF N_("Searchable and filterable from the web user interface."),
"\n* ",
LANGPREF N_("Results can be scheduled for recording with a single click."),
"\n\n##### ",
LANGPREF N_("Rich Browser-Driven Interface"),
"\n\n* ",
LANGPREF N_("The entire application is loaded into the browser."),
"\n* ",
LANGPREF N_("Based on extJS, all pages are dynamic and self-refreshing."),
"\n* ",
LANGPREF N_("All sorting/filtering is then done in C by the main application for speed."),
"\n\n##### ",
LANGPREF N_("Easy to Configure and Administer"),
"\n\n* ",
LANGPREF N_("All setup and configuration is done from the built in web user interface."),
"\n* ",
LANGPREF N_("All settings are stored in human-readable text files."),
"\n* ",
LANGPREF N_("Initial setup can be done by choosing one of the pre-defined"),
" [",
LANGPREF N_("linuxtv"),
"](http://git.linuxtv.org/cgit.cgi/dtv-scan-tables.git) ",
LANGPREF N_("networks or manually configured."),
"\n* ",
LANGPREF N_("Idle scanning for automatic detection of muxes and services."),
"\n* ",
LANGPREF N_("Support for broadcaster (primarily DVB-S) bouquets for easy channel mapping."),
" \n\n##### ",
LANGPREF N_("Multi-User Support"),
"\n\n* ",
LANGPREF N_("Access to system features (streaming, administration, configurations) can be configured based on username/password and/or IP address."),
"\n\n##### ",
LANGPREF N_("Software-Based CSA Descrambling"),
"\n\n* ",
LANGPREF N_("Requires a card server (newcamd and capmt protocol is supported)."),
"\n\n##### ",
LANGPREF N_("Fully-Integrated with Mainstream Media Players"),
"\n\n* ",
LANGPREF N_("Movian and Kodi are the main targets."),
"\n* ",
LANGPREF N_("All channel data, channel groups/tags, EPG and TV streaming is carried over a single TCP connection."),
"\n\n##### ",
LANGPREF N_("Mobile/Remote Client Support"),
"\n\n* ",
LANGPREF N_("As well as the web interface, which is accessible through VPN if required, third-party clients are available for both"),
" [",
LANGPREF N_("Android"),
"](https://play.google.com/store/apps/details?id=org.tvheadend.tvhclient&hl=en_GB) ",
LANGPREF N_("and"),
" [",
LANGPREF N_("iOS"),
"](https://itunes.apple.com/gb/app/tvhclient/id638900112?mt=8) ",
LANGPREF N_("(other clients may also be available)."),
"\n\n##### ",
LANGPREF N_("Internationalisation"),
"\n\n* ",
LANGPREF N_("All text is encoded in UTF-8 to provide full international support."),
"\n* ",
LANGPREF N_("All major character encodings in DVB are supported (e.g. for localised EPG character sets)."),
"\n* [",
LANGPREF N_("Web interface internationalization"),
"](https://tvheadend.org/projects/tvheadend/wiki/Internationalization)\n",

NULL
};

const char *tvh_doc_root_index[] = {
"## ",
LANGPREF N_("Tvheadend 4.2 User Guide"),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("Tvheadend Logo"),
"](static/img/doc/index/logo.png)\n\n## ",
LANGPREF N_("Purpose"),
"\n\n",
LANGPREF N_("This document is intended to give you a high-level overview of how to set up Tvheadend for the first time. It does not aim to provide a complete description of every step or answer every question: more details are available on the tvheadend"),
" [",
LANGPREF N_("wiki"),
"](https://tvheadend.org/projects/tvheadend/wiki)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("As you set things up, consult the on-line (web interface) help as well. Tvheadend includes copies of many of these pages in the application, which is easier to find when you're wondering what to do next."),
"\n\n",
LANGPREF N_("If you get really stuck, there's the"),
" [",
LANGPREF N_("forum"),
"](https://tvheadend.org/projects/tvheadend/boards) ",
LANGPREF N_("and IRC (_#hts_ on _freenode_ ) -"),
" [",
LANGPREF N_("Kiwi IRC"),
"](https://kiwiirc.com/client/chat.freenode.net/?nick=tvhhelp|?#hts) ",
LANGPREF N_("or Freenode's"),
" [",
LANGPREF N_("webchat"),
"](http://webchat.freenode.net) ",
LANGPREF N_("are good web clients if you don't already have an IRC client installed."),
"\n",

NULL
};

const char *tvh_doc_root_install_hardware[] = {
"### ",
LANGPREF N_("Install Your Tuners"),
"\n\n",
LANGPREF N_("This section will give you some basic ideas on how to get your tuner working with your operating system. However, it's clearly way beyond the scope of this guide to tell you everything: consult specialist forums, search around, and at least do some research to work out what's likely to work or not before you hand over any money."),
"\n\n",
LANGPREF N_("There is a discussion about supported hardware on"),
" [",
LANGPREF N_("the Tvheadend forums"),
"](https://tvheadend.org/boards/5/topics/5102)",
LANGPREF N_("."),
"\n\n#### ",
LANGPREF N_("1. Install the Tuner Hardware"),
"\n\n",
LANGPREF N_("This is obviously a core requirement that's outside of the scope of this guide."),
"\n\n",
LANGPREF N_("You basically have the choice of:"),
"\n\n* ",
LANGPREF N_("External USB tuners that plug in"),
"\n* ",
LANGPREF N_("Internal (e.g. PCI) tuners that go inside the computer chassis"),
"\n* ",
LANGPREF N_("External SAT>IP tuners that send MPEG-TS streams over a LAN connection"),
"\n* ",
LANGPREF N_("External HDHomeRun tuners that send MPEG-TS streams over a LAN connection"),
"\n\n",
LANGPREF N_("Follow the appropriate installation instructions and, if relevant, the setup instruction (e.g. for SAT>IP, which are effectively small, standalone computers)."),
"\n\n##### ",
LANGPREF N_("A Note on USB Tuners"),
"\n\n",
LANGPREF N_("USB tuners are cheap, work well and are frequently well-matched to physically-smaller builds (e.g. HTPCs) which simply don't have the internal slots. However, please remember that many need external power, or need a powered hub to work properly."),
"\n\n",
LANGPREF N_("In addition, even USB3 doesn't have the greatest practical bandwidth per bus. That means you're probably asking for problems if you have four DVB-S2 dongles on the same USB connection to the motherboard."),
"\n\n",
LANGPREF N_("This is particularly true of systems such as the Raspberry Pi which share USB bandwidth with the Ethernet port. Don't be surprised if this kind of platform struggles and/or reports errors in a multi-tuner configuration, especially on high-bandwidth (e.g. HD) streams."),
"\n\n#### ",
LANGPREF N_("2. Install Firmware and/or Drivers"),
"\n\n",
LANGPREF N_("Similar to the above, Tvheadend can do nothing if your tuners aren't working properly. A good place to check how to set up your tuners is the"),
" [",
LANGPREF N_("LinuxTV wiki device library"),
"](http://www.linuxtv.org/wiki/index.php/Hardware_Device_Information) ",
LANGPREF N_("- this will not only tell you what's supported under Linux, but also how to get it all working."),
"\n\n",
LANGPREF N_("As a broad guide, though, you need two main components: a driver, and firmware."),
" \n\n",
LANGPREF N_("The __driver__ is the piece of software that, as far as the operating system is concerned, controls the tuner hardware."),
" \n\n",
LANGPREF N_("Driver software typically comes either built-in to the operating system (a clue here is documentation that says _\"supported since kernel 3.16\"_ , for example) or as an external program that needs to be compiled in (e.g. how you'd build TBS' or Digital Devices drivers, or perhaps where the driver is supported in a later version of LinuxTV V4L-DVB than has made it to your kernel - the giveaway here is _\"compile and install the latest media_build\"_ )."),
"\n\n",
LANGPREF N_("Many tuners then also require __firmware__ - normally, a binary file that's been extracted from the proprietary drivers used by Windows."),
"\n\n",
LANGPREF N_("Many Linux distros include a package for the most common devices (e.g. _linux-firmwares_ under Ubuntu or _firmware-linux-nonfree_ under Debian). If this isn't sufficient, a good source of firmware files are the"),
" [",
LANGPREF N_("OpenElec"),
"](https://github.com/OpenELEC/dvb-firmware) ",
LANGPREF N_("and"),
" [",
LANGPREF N_("LibreELEC"),
"](https://github.com/libreELEC/dvb-firmware) ",
LANGPREF N_("firmware repositories on Github."),
"\n\n",
LANGPREF N_("Typically, download the binary file and install it into `/lib/firmware`, owned by `root:root`, permissions `rw-r--r--` (0644)"),
"\n",

NULL
};

const char *tvh_doc_root_install_tvheadend[] = {
"### ",
LANGPREF N_("Install Tvheadend"),
"\n\n",
LANGPREF N_("This section tells you how to get hold of the software in the first place, and how to get it onto your system."),
"\n\n",
LANGPREF N_("Follow the instructions that are specific to your Linux distribution (Ubuntu/Debian/Mint, Arch, Fedora...). This will typically be PPA-and-dpkg for Debian, but most other distros will need you to build your own version from source."),
"\n\n* [",
LANGPREF N_("Debian/Ubuntu installation instructions"),
"](https://tvheadend.org/projects/tvheadend/wiki/AptRepository)\n* [",
LANGPREF N_("Instructions on how to build from source"),
"](https://tvheadend.org/projects/tvheadend/wiki/Building)\n\n",
LANGPREF N_("Do not assume that your distro's package manager will give you the latest version of Tvheadend - indeed, give you any version at all. Always check."),
"\n\n",
LANGPREF N_("Where a pre-built package exists, this will usually get you the last official stable version. However, more advanced users may be interested in running a development version - either a nightly build or a self-compiled version."),
"\n",

NULL
};

const char *tvh_doc_root_markdown_cribsheet[] = {
"### ",
LANGPREF N_("Markdown/Formatting Crib Sheet"),
"\n\n",
LANGPREF N_("Some notable items about how formatting is used on this particular site."),
"\n\n",
LANGPREF N_("In general, __keep it simple__ , especially if you're contributing to the pages that get carried over into the web help. The simpler the formatting, the cleaner the conversion, the less tidying up there is afterwards."),
"\n\n#### ",
LANGPREF N_("References"),
"\n\n* ",
LANGPREF N_("Markdown basics:"),
" [",
LANGPREF N_("GitHub mastering markdown"),
"](https://guides.github.com/features/mastering-markdown)\n\n#### ",
LANGPREF N_("Including Documentation/Items"),
"\n\n",
LANGPREF N_("You can include documentation/items in other markdown files by using the tvh_class_doc, tvh_include and tvh_class_items tags."),
"\n\n",
LANGPREF N_("For example to include the passwd items you'd enter something like this:"),
"\n```no-highlight\n<tvh_class_items>passwd</tvh_class_items>\n```\n\n",
LANGPREF N_("To include class documentation you'd use:"),
"\n```no-highlight\n<tvh_class_doc>passwd</tvh_class_doc>\n```\n\n",
LANGPREF N_("To include multi-use docs (placed in the `docs/markdown/inc/` folder:"),
"\n```no-highlight\n<tvh_include>inc/common_button_table_end</tvh_include>\n```\n\n#### ",
LANGPREF N_("Paragraphs Versus Definition Lists"),
"\n\n",
LANGPREF N_("Watch this one - indentation is key."),
"\n\n",
LANGPREF N_("__This is paragraph formatting__ : with a subsequent explanation"),
"\n```no-highlight\n**This is paragraph formatting**\n: with a subsequent explanation\n\n```\n\n",
LANGPREF N_("__This is definition list formatting__ : with a subsequent explanation"),
"\n```no-highlight\n**This is definition list formatting**\n:   with a subsequent explanation\n\n```\n\n",
LANGPREF N_("They may render the same here, but note the extra leading spaces in the second example: this means that they will convert differently for use in the web interface help. That in turn means your formatting will be all over the place unless you handle the dl/dt/dd formatting in Tvheadend's CSS."),
" \n\n",
LANGPREF N_("Stick to paragraph formatting unless and until you have a need for definition lists."),
"\n\n#### ",
LANGPREF N_("Lists"),
"\n\n",
LANGPREF N_("Mixed lists don't work without further python extensions. Be careful."),
"\n```no-highlight\n1. First ordered list item\n2. Another item\n  * Unordered sub-list. \n1. Actual numbers don't matter, just that it's a number\n  1. Ordered sub-list\n4. And another item.\n\n   You can't have have properly indented paragraphs within list items. \n\n* Unordered list can use asterisks\n- Or minuses\n+ Or pluses\n\nOh, and\n\n77. Each numbered (ordered) list will restart from 1.\n```\n\n",
LANGPREF N_("... produces:"),
"\n\n1. ",
LANGPREF N_("First ordered list item"),
"\n2. ",
LANGPREF N_("Another item"),
"\n  * ",
LANGPREF N_("Unordered sub-list."),
" \n3. ",
LANGPREF N_("Actual numbers don't matter, just that it's a number"),
"\n  1. ",
LANGPREF N_("Ordered sub-list"),
"\n4. ",
LANGPREF N_("And another item."),
"\n  ",
LANGPREF N_("You can't have have properly indented paragraphs within list items."),
" \n5. ",
LANGPREF N_("Unordered list can use asterisks"),
"\n6. ",
LANGPREF N_("Or minuses"),
"\n7. ",
LANGPREF N_("Or pluses"),
"\n\n",
LANGPREF N_("Oh, and"),
"\n\n1. ",
LANGPREF N_("Each numbered (ordered) list will restart from 1."),
"\n\n#### ",
LANGPREF N_("Tables"),
"\n\n",
LANGPREF N_("Tables can be constructed as follows."),
"\n\n",
LANGPREF N_("The markup code:"),
"\n```no-highlight\nFirst Header                | Second Header\n--------------------------- | -------------\nContent from cell 1         | Content from cell 2\nContent in the first column | Content in the second column\n\n```\n\n",
LANGPREF N_("Will generate:"),
"\n\n",
LANGPREF N_("First Header"),
" | ",
LANGPREF N_("Second Header"),
"\n----- | -----\n",
LANGPREF N_("Content from cell 1"),
" | ",
LANGPREF N_("Content from cell 2"),
"\n",
LANGPREF N_("Content in the first column"),
" | ",
LANGPREF N_("Content in the second column"),
"\n\n",
LANGPREF N_("And if you don't want a header, you can leave it out - but the cells remain in this theme, so I'd suggest you don't do this as it's ugly:"),
"\n```no-highlight\n | \n--------------------------- | -------------\nHeadless table cell 1       | Content from cell 2\nContent in the first column | Content in the second column\n\n```\n\n ",
LANGPREF N_("| --------------------------- | ------------- Headless table cell 1 | Content from cell 2 Content in the first column | Content in the second column"),
"\n\n",
LANGPREF N_("We're using default heading/cell justification, so it's consistent throughout."),
"\n",

NULL
};

const char *tvh_doc_root_overview[] = {
"### ",
LANGPREF N_("Overview of Tvheadend"),
"\n\n#### ",
LANGPREF N_("Welcome to Tvheadend!"),
"\n\n",
LANGPREF N_("Tvheadend is a lightweight, easily-configured, general-purpose TV/video streaming server and recorder (PVR/DVR) for GNU/Linux, FreeBSD and Android."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("Tvheadend interface"),
"](static/img/doc/overview/screenshot.png)\n\n",
LANGPREF N_("It supports input from:"),
"\n\n* ",
LANGPREF N_("Cable TV, delivered via a cable to your house (DVB-C)"),
"\n* ",
LANGPREF N_("Satellite, so any signal coming in via a dish (DVB-S and DVB-S2)"),
"\n* ",
LANGPREF N_("Terrestrial, so over-the-air broadcasts received through a traditional television aerial (DVB-T and DVB-T2 in much of the world, ATSC in north and central America)"),
"\n* ",
LANGPREF N_("Internet and LAN feeds, such as IPTV, SAT>IP, HDHomeRun and a general-purpose MPEG-TS `pipe://`"),
"\n\n",
LANGPREF N_("As well as being able to record the input, Tvheadend also offers it up to client applications via HTTP (VLC, MPlayer), HTSP (Kodi, Movian) and SAT>IP streaming."),
"\n\n",
LANGPREF N_("While supported in previous versions, analogue video (V4L) is no longer supported directly. If you still need this, or need to input signals from video cameras or other non-broadcast sources, use `pipe://`."),
"\n\n",
LANGPREF N_("The code is hosted at"),
" [",
LANGPREF N_("github"),
"](https://github.com/tvheadend/tvheadend)",
LANGPREF N_(". Please use github's features if you want to provide patches. Contributions and improvements are always welcome."),
"\n",

NULL
};

const char *tvh_doc_root_requirements[] = {
"### ",
LANGPREF N_("Basic Requirements"),
"\n\n#### ",
LANGPREF N_("Physical Architecture"),
"\n\n",
LANGPREF N_("It's perfectly possible to install and run Tvheadend as a single-seat installation, with the software running on the same system as any client software (e.g. Kodi), with all files stored locally."),
"\n\n",
LANGPREF N_("Alternatively, you can run Tvheadend on a server, perhaps on an always-on system that houses your media, perhaps on a dedicated low-power system - it's your choice."),
"\n\n",
LANGPREF N_("Where you have aerial/coax connections might influence your choice - unless you use SAT>IP or have some other way to transport your TV signal over a LAN, your Tvheadend installation has to live where you can actually connect your tuners."),
" \n\n#### ",
LANGPREF N_("System Requirements"),
"\n\n",
LANGPREF N_("Wherever you install it, Tvheadend primarily runs on __Linux__ - pre-built binaries are available for most Debian-based distributions (Debian itself, Ubuntu, Mint...) and RPMs for Fedora, or you can build it yourself. It runs on both 32- and 64-bit x86 and ARM processors, and so also can be built for Android (which uses the Linux kernel)."),
"\n\n",
LANGPREF N_("You will only need __c. 30MB disk space__ for the application and associated files, and maybe anything up to __1GB__ for your configuration - depending on how many tuners of what type you have, how many channels you receive, your choice of programme guide, and so on. You'll clearly need much more for your recordings, though: as a guide, an hour of SD MPEG-2 video will take about 1GB, while high bitrate HD H.264 will easily consume 5GB+ per hour."),
"\n\n",
LANGPREF N_("Tvheadend is intended to be lightweight, so it will run on a NAS or similar __low-powered CPU__ . Note that the exception here is transcoding: if you want to convert high-definition video in real time then you will need a powerful, multi-core system. It will happily run in less than __1GB of RAM__ , and many people run it successfully on original Raspberry Pis with perhaps only 256MB of usable free memory. This does depend on what else you're using the computer for, though, as a GUI will drain your system as will any serious file serving."),
"\n\n",
LANGPREF N_("And, of course, you'll need one or more __TV tuners__ if you want to receive regular broadcast television - otherwise, you're limited to IP sources."),
"\n\n",
LANGPREF N_("An __Internet connection__ is recommended but not essential. You need to have an accurate clock for EPG timers to work, for example, but this can be synchronised from the broadcast signal if you're not in a position to use `ntp` or similar."),
"\n\n#### ",
LANGPREF N_("How Lightweight?"),
"\n\n",
LANGPREF N_("How about light enough to run on a travel router? Take a look at this"),
" [",
LANGPREF N_("example"),
"](https://tvheadend.org/boards/4/topics/16579) ",
LANGPREF N_("from one of our users..."),
"\n",

NULL
};

const char *tvh_doc_root_status_connections[] = {
"### ",
LANGPREF N_("Status - Connections"),
"\n\n",
LANGPREF N_("This tab shows information about all active connections."),
"\n\n",
LANGPREF N_("This is a read-only tab; nothing is configurable."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Status - Subscriptions' Tab"),
"](static/img/doc/status_connections/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Grid Items"),
"\n\n",
LANGPREF N_("The main grid items have the following functions:"),
"\n\n",
LANGPREF N_("__Cancel Icon !"),
"[",
LANGPREF N_("'Cancel'"),
"](static/icons/cancel.png)",
LANGPREF N_("__ : Forcefully kill the connection. Note that many applications such as Kodi will automatically reconnect when a connection is dropped."),
"\n\n",
LANGPREF N_("__Type__ : Connection type - HTSP or HTTP."),
"\n\n",
LANGPREF N_("__IP Address__ : The IP address of the device."),
" \n\n",
LANGPREF N_("__Username__ : The username used to access tvheadend (a blank cell indicates no username was supplied)."),
"\n\n",
LANGPREF N_("__Started__ : Date the connection started - YYYY-MM-DD HH:MM:SS."),
"\n",

NULL
};

const char *tvh_doc_root_status_service_mapper[] = {
"### ",
LANGPREF N_("Service Mapper"),
"\n\n",
LANGPREF N_("This tab shows information about current service mapping activity."),
" \n\n",
LANGPREF N_("This is a read-only tab; nothing is configurable."),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Status - Subscriptions' Tab"),
"](static/img/doc/status_service_mapper/tab.png) \n\n",
LANGPREF N_("The"),
" [",
LANGPREF N_("Map services to channels"),
"](class/service_mapper) ",
LANGPREF N_("dialog determines how services are mapped."),
"\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Items"),
"\n\n",
LANGPREF N_("__Mapped__ : Number of services mapped."),
" \n\n",
LANGPREF N_("__Ignored__ : Number of services ignored."),
" \n\n",
LANGPREF N_("__Failed__ : Number of services that failed to be mapped."),
"\n\n",
LANGPREF N_("__Active__ : Progress bar indicating mapping status."),
"\n",

NULL
};

const char *tvh_doc_root_status_stream[] = {
"### ",
LANGPREF N_("Status - Stream"),
"\n\n",
LANGPREF N_("This tab shows information about all currently-open streams."),
"\n\n",
LANGPREF N_("This is a read-only tab; nothing is configurable."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Status - Stream' Tab"),
"](static/img/doc/status_stream/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Items"),
"\n\n",
LANGPREF N_("The main grid items have the following functions:"),
"\n\n",
LANGPREF N_("__Sweep/Clean Icon !"),
"[",
LANGPREF N_("'Status - Stream' Tab"),
"](static/icons/clean.png)",
LANGPREF N_("__ : Clear all \"Uncorrected Blocks\", \"BER\", etc stats."),
" \n\n",
LANGPREF N_("__Input__ : Device used to receive the stream."),
"\n\n",
LANGPREF N_("__Sub No__ : Number of subscriptions using the stream."),
"\n\n",
LANGPREF N_("__Weight__ : Stream weighting."),
" \n\n",
LANGPREF N_("__Bandwidth__ : Total stream input bandwidth."),
"\n\n",
LANGPREF N_("__BER__ :"),
" [",
LANGPREF N_("Bit Error Ratio"),
"](https://en.wikipedia.org/wiki/Bit_error_rate)\n\n",
LANGPREF N_("__PER__ :"),
" [",
LANGPREF N_("Packet Error Ratio"),
"](https://en.wikipedia.org/wiki/Bit_error_rate#Packet_error_ratio)\n\n",
LANGPREF N_("__Uncorrected Blocks__ : Number of uncorrected blocks. A value higher than 0 can indicate a weak signal or interference, note that some devices can send a false value."),
"\n\n",
LANGPREF N_("__Transport Errors__ : Number of transport streams errors. A fast increasing value here can indicate signal issues. Device drivers can sometimes send garbage data at the beginning of a stream, as long as the value doesn't increase at a fast pace and you have no playback issues, there is nothing to worry about."),
"\n\n",
LANGPREF N_("__Continuity Errors__ : Continuity Count Error. Number of stream errors, a high value here can indicate a signal problem."),
"\n\n",
LANGPREF N_("__SNR__ : Signal (To) Noise Ratio."),
" [",
LANGPREF N_("The level of a desired signal to the level of background noise"),
"](https://en.wikipedia.org/wiki/Signal-to-noise_ratio)",
LANGPREF N_(", note that not all devices supply correct signal information, the value here can sometimes be ambiguous."),
"\n\n",
LANGPREF N_("__Signal Strength__ : The signal strength as reported by the device, note that not all devices supply correct signal information, the value here can sometimes be ambiguous"),
"\n",

NULL
};

const char *tvh_doc_root_status_subscriptions[] = {
"### ",
LANGPREF N_("Status - Subscriptions"),
"\n\n",
LANGPREF N_("This tab shows information about all active subscriptions to Tvheadend."),
"\n\n",
LANGPREF N_("This is a read-only tab; nothing is configurable."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Status - Subscriptions' Tab"),
"](static/img/doc/status_subscriptions/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n##### ",
LANGPREF N_("Items"),
"\n\n",
LANGPREF N_("The main grid items have the following functions:"),
"\n\n",
LANGPREF N_("__ID__ : Subscription ID."),
"\n\n",
LANGPREF N_("__Hostname__ : Hostname/IP address using the subscription."),
"\n\n",
LANGPREF N_("__Username__ : Username using the subscription - a blank cell indicates the subscriber didn't supply a username."),
"\n\n",
LANGPREF N_("__Title__ : Title of the application using the subscription - you will sometimes see \"epggrab\" here, this is an internal subscription used by tvheadend to grab EPG data."),
"\n\n",
LANGPREF N_("__Channel__ : The name of the"),
" [",
LANGPREF N_("channel"),
"](class/channel) ",
LANGPREF N_("the subscription is using - if the subscription is streaming a service/mux this cell will be blank."),
"\n\n",
LANGPREF N_("__Profile__ : The name of the"),
" [",
LANGPREF N_("profile"),
"](class/profile) ",
LANGPREF N_("the subscription is using."),
"\n\n",
LANGPREF N_("__Start__ : The date (and time) the subscription was started."),
"\n\n",
LANGPREF N_("__State__ : The status of the subscription"),
"\n\n",
LANGPREF N_("State"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n",
LANGPREF N_("Running"),
" | ",
LANGPREF N_("The subscription is active - the stream is being sent."),
"\n",
LANGPREF N_("Idle"),
" | ",
LANGPREF N_("The subscription is idling, waiting for the subscriber."),
"\n",
LANGPREF N_("Testing"),
" | ",
LANGPREF N_("Tvheadend is testing the requested stream to see if it's available - if a subscription stays in this state too long it may indicate a signal issue."),
"\n\n",
LANGPREF N_("__Descramble__ : The CAID used to descramble the stream."),
"\n\n",
LANGPREF N_("__Errors__ : Number of errors occurred sending the stream."),
"\n\n",
LANGPREF N_("__Input__ : The input data rate in kb/s."),
"\n\n",
LANGPREF N_("__Output__ : The output data rate in kb/s."),
"\n",

NULL
};

const char *tvh_doc_root_toc[] = {
"##### ",
LANGPREF N_("Table of Contents"),
"\n\n[",
LANGPREF N_("Introduction"),
"](index)\n\n* [",
LANGPREF N_("Overview"),
"](overview)\n* [",
LANGPREF N_("Basic Requirements"),
"](requirements)\n* [",
LANGPREF N_("Features"),
"](features)\n\n",
LANGPREF N_("Getting Started"),
"\n\n* [",
LANGPREF N_("Before you begin (concepts)"),
"](before_begin)\n* [",
LANGPREF N_("Install hardware"),
"](install_hardware)\n* [",
LANGPREF N_("Install Tvheadend"),
"](install_tvheadend)\n* [",
LANGPREF N_("Configure Tvheadend"),
"](configure_tvheadend)\n\n",
LANGPREF N_("Web Interface Guide"),
"\n\n* [",
LANGPREF N_("General"),
"](webui_general)\n* [",
LANGPREF N_("Electronic Program Guide"),
"](epg)\n* ",
LANGPREF N_("Digital Video Recorder"),
"\n  * [",
LANGPREF N_("Upcoming / Current Recordings"),
"](class/dvrentry)\n  * [",
LANGPREF N_("Finished Recordings"),
"](class/dvrentry)\n  * [",
LANGPREF N_("Failed Recordings"),
"](class/dvrentry)\n  * [",
LANGPREF N_("Removed Recordings"),
"](class/dvrentry)\n  * [",
LANGPREF N_("Auto-recording (Autorecs)"),
"](class/dvrautorec)\n  * [",
LANGPREF N_("Time-based Recording (Timers)"),
"](class/dvrtimerec)\n* ",
LANGPREF N_("Configuration"),
"\n  * ",
LANGPREF N_("General"),
"\n    * [",
LANGPREF N_("Base"),
"](class/config)\n    * [",
LANGPREF N_("Image Cache"),
"](class/imagecache)\n    * [",
LANGPREF N_("SAT>IP Server"),
"](class/satip_server)\n  * ",
LANGPREF N_("Users"),
"\n    * [",
LANGPREF N_("Access Entries"),
"](class/access)\n    * [",
LANGPREF N_("Passwords"),
"](class/passwd)\n    * [",
LANGPREF N_("IP Address Block List"),
"](class/ipblocking)\n  * ",
LANGPREF N_("DVB Inputs"),
"\n    * [",
LANGPREF N_("TV Adapters"),
"](tv_adapters)\n    * [",
LANGPREF N_("Networks"),
"](class/mpegts_network)\n    * [",
LANGPREF N_("Muxes"),
"](class/mpegts_mux)\n    * [",
LANGPREF N_("Services"),
"](class/mpegts_service)\n    * [",
LANGPREF N_("Mux Schedulers"),
"](class/mpegts_mux_sched)\n  * ",
LANGPREF N_("Channel / EPG"),
"\n    * [",
LANGPREF N_("Channels"),
"](class/channel)\n    * [",
LANGPREF N_("Channel Tags"),
"](class/channeltag)\n    * [",
LANGPREF N_("Bouquets"),
"](class/bouquet)\n    * [",
LANGPREF N_("EPG Grabber Channels"),
"](class/epggrab_channel)\n    * [",
LANGPREF N_("EPG Grabber"),
"](class/epggrab)\n    * [",
LANGPREF N_("EPG Grabber Modules"),
"](class/epggrab_mod)\n      * [",
LANGPREF N_("OTA Module"),
"](class/epggrab_mod_ota)\n      * [",
LANGPREF N_("Internal PyEPG"),
"](class/epggrab_mod_int_pyepg)\n      * [",
LANGPREF N_("Internal XMLTV"),
"](class/epggrab_mod_int_xmltv)\n      * [",
LANGPREF N_("External PyEPG"),
"](class/epggrab_mod_ext_pyepg)\n      * [",
LANGPREF N_("External XMLTV"),
"](class/epggrab_mod_ext_xmltv)\n  * ",
LANGPREF N_("Stream"),
"\n    * ",
LANGPREF N_("Stream Profiles"),
"\n      * [",
LANGPREF N_("HTSP Profile"),
"](class/profile-htsp)\n      * [",
LANGPREF N_("MPEG-TS Pass-thru Profile"),
"](class/profile-mpegts)\n      * [",
LANGPREF N_("Matroska Profile"),
"](class/profile-matroska)\n      * [",
LANGPREF N_("MPEG-TS/libav Profile"),
"](class/profile-libav-mpegts)\n      * [",
LANGPREF N_("Matroska/libav Profile"),
"](class/profile-libav-matroska)\n      * [",
LANGPREF N_("MP4/libav Profile"),
"](class/profile-libav-mp4)\n      * [",
LANGPREF N_("Transcode Profile"),
"](class/profile-transcode)\n    * [",
LANGPREF N_("Video Stream Filters"),
"](class/esfilter_video)\n    * [",
LANGPREF N_("Audio Stream Filters"),
"](class/esfilter_audio)\n    * [",
LANGPREF N_("Teletext Stream Filters"),
"](class/esfilter_teletext)\n    * [",
LANGPREF N_("Subtitle Stream Filters"),
"](class/esfilter_subtit)\n    * [",
LANGPREF N_("CA Stream Filters"),
"](class/esfilter_ca)\n    * [",
LANGPREF N_("Other Stream Filters"),
"](class/esfilter_other)\n  * ",
LANGPREF N_("Recording"),
"\n    * [",
LANGPREF N_("Digital Video Recorder Profiles"),
"](class/dvrconfig)\n    * [",
LANGPREF N_("Timeshift"),
"](class/timeshift)\n  * ",
LANGPREF N_("Conditional Access (CA)"),
"\n    * [",
LANGPREF N_("CAPMT (Linux Network DVBAPI)"),
"](class/caclient_capmt)\n    * [",
LANGPREF N_("Code word client (newcamd)"),
"](class/caclient_cwc)\n    * [",
LANGPREF N_("DES constant code word client"),
"](class/caclient_ccw_des)\n    * [",
LANGPREF N_("AES constant code word client"),
"](class/caclient_ccw_aes)\n  * [",
LANGPREF N_("Debugging"),
"](class/tvhlog_conf)\n  * ",
LANGPREF N_("Status"),
"\n    * [",
LANGPREF N_("Stream"),
"](status_stream)\n    * [",
LANGPREF N_("Subscriptions"),
"](status_subscriptions)\n    * [",
LANGPREF N_("Connections"),
"](status_connections)\n    * [",
LANGPREF N_("Server Mapper"),
"](status_service_mapper)\n  * [",
LANGPREF N_("About"),
"](webui_about)\n\n",
LANGPREF N_("Appendices"),
"\n\n* [",
LANGPREF N_("Appendix 1 - URL syntax (Exports)"),
"](url)\n* [",
LANGPREF N_("Appendix 2 - FAQ"),
"](faqs)\n* [",
LANGPREF N_("Appendix 3 - Command-line Options"),
"](cmdline_options)\n* [",
LANGPREF N_("Appendix 4 - Updating this documentation"),
"](doc_update)\n* [",
LANGPREF N_("Appendix 5 - Markdown Cribsheet"),
"](markdown_cribsheet)\n\n[",
LANGPREF N_("About"),
"](doc_about)\n",

NULL
};

const char *tvh_doc_root_todo[] = {
"### ",
LANGPREF N_("Things To Do on This Guide..."),
"\n\n##### ",
LANGPREF N_("Work-in-progress notes"),
"\n\n",
LANGPREF N_("These are not part of the final product, obviously!"),
"\n\n",
LANGPREF N_("They're just some of the areas I'm aware of that we need to close off before release"),
"\n\n1. ",
LANGPREF N_("Complete the content for 4.0 (4.2 can wait) - strip out what isn't stricly necessary now (we can come back)"),
"\n2. ",
LANGPREF N_("Check non-univeral (i.e. item-specific) configuration items (e.g. the IPTV mux parameters) and make sure they're documented"),
"\n3. ",
LANGPREF N_("Obviously, fill in the minor gaps as highlighted in the document: buttons, descriptions, etc."),
"\n4. ",
LANGPREF N_("Generate new webUI help pages and push them to the tvheadend repo"),
"\n5. ",
LANGPREF N_("Check all link from tvh (e.g. there are no help buttons on the 'Stream' tabs)"),
"\n\n",
LANGPREF N_("The following major content items/chapters are then missing - based on most FAQs on the forum:"),
"\n\n* ",
LANGPREF N_("Transcoding (updated for 4.2, so needs to be tagged properly and reversed as applicable to 4.0)"),
"\n* ",
LANGPREF N_("How to configure a recording"),
"\n* ",
LANGPREF N_("How to watch Live TV"),
"\n* ",
LANGPREF N_("How to set up conditional access (\"Conditional Access System Configuration\")"),
"\n* ",
LANGPREF N_("How to set up a multi-profile installation (access)"),
"\n* ",
LANGPREF N_("How to compile/install on _insert your distro here_"),
" \n* ",
LANGPREF N_("Setting up SAT>IP - as a client, as a server"),
"\n* ",
LANGPREF N_("Platform differences - what you need to transcode, or what you can expect from Android vs GNU/Linux"),
"\n* ",
LANGPREF N_("Platform differences - Ubuntu, Fedora, Red Hat, Arch, Android..."),
"\n* ",
LANGPREF N_("HD Homerun setup"),
"\n* ",
LANGPREF N_("/etc/default/tvheadend options"),
"\n* ",
LANGPREF N_("Expand a bit on command-line options and give some examples of common usage"),
"\n\n",
LANGPREF N_("And I'm left with these final open questions:"),
"\n\n* ",
LANGPREF N_("We need the webUI pages documented (as they are). How much should they be the how-tos, and how much should these be separate?"),
"\n* ",
LANGPREF N_("How deep do we want to (need to) get into setting up tuners - that's a constant source of woe for people?"),
"\n* ",
LANGPREF N_("If we do all the above, do we need the FAQ pages? Check existing manual/guide"),
"\n",

NULL
};

const char *tvh_doc_root_tv_adapters[] = {
"### ",
LANGPREF N_("DVB Inputs - TV Adapters"),
"\n\n",
LANGPREF N_("The adapters and tuners are listed and edited in a tree."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'TV Adapter tree'"),
"](static/img/doc/tv_adapters/tree.png)\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Device Tree"),
"\n\n",
LANGPREF N_("The device tree lists the available frontends, LNB configuration and so on related to your device(s) in sections. Clicking on these sections will display available parameters and device information."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'TV Adapter params'"),
"](static/img/doc/tv_adapters/params.png)\n\n",
LANGPREF N_("__Tip__ : Remember to save your changes _before_ switching panels."),
"\n\n---\n\n#### ",
LANGPREF N_("Device Configuration"),
"\n\n",
LANGPREF N_("Click on an item to display more information."),
"\n\n##### ",
LANGPREF N_("Satellite (DVB-S/ISDB-S)"),
"\n\n* ",
LANGPREF N_("Frontend"),
"\n  * [",
LANGPREF N_("Master"),
"](class/linuxdvb_frontend_dvbs)\n  * [",
LANGPREF N_("Master (ISDB-S)"),
"](class/linuxdvb_frontend_isdb_s)\n  * [",
LANGPREF N_("Slave"),
"](class/linuxdvb_frontend_dvbs_slave)\n* ",
LANGPREF N_("Satellite Configuration"),
"\n  * [",
LANGPREF N_("Universal LNB"),
"](class/linuxdvb_satconf_lnbonly)\n  * [",
LANGPREF N_("2 Port"),
"](class/linuxdvb_satconf_2port)\n  * [",
LANGPREF N_("4 Port"),
"](class/linuxdvb_satconf_4port)\n* ",
LANGPREF N_("Satellite Configuration (Advanced)"),
"\n  * [",
LANGPREF N_("Advanced LNB"),
"](class/linuxdvb_satconf_advanced)\n  * [",
LANGPREF N_("Unicable EN50494 (experimental)"),
"](class/linuxdvb_satconf_en50494)\n  * [",
LANGPREF N_("DiseqC Rotor"),
"](class/linuxdvb_rotor)\n  * [",
LANGPREF N_("DiSEqC Switch"),
"](class/linuxdvb_switch)\n  * [",
LANGPREF N_("Rotor (GOTOX)"),
"](class/linuxdvb_rotor_gotox)\n  * [",
LANGPREF N_("Rotor (USALS)"),
"](class/linuxdvb_rotor_usals)\n\n##### ",
LANGPREF N_("Terrestrial (DVB-T/ATSC-T/ISDB-T)"),
"\n\n* ",
LANGPREF N_("Frontend"),
"\n  * [",
LANGPREF N_("DVB-T/DVB-T2"),
"](class/linuxdvb_frontend_dvbt)\n  * [",
LANGPREF N_("ATSC-T"),
"](class/linuxdvb_frontend_atsc_t)\n  * [",
LANGPREF N_("ISDB-T"),
"](class/linuxdvb_frontend_isdb_t)\n\n##### ",
LANGPREF N_("Cable (DVB-C/ATSC-C/ISDB-C)"),
"\n\n* ",
LANGPREF N_("Frontend"),
"\n  * [",
LANGPREF N_("DVB-C"),
"](class/linuxdvb_frontend_dvbc)\n  * [",
LANGPREF N_("ATSC-C"),
"](class/linuxdvb_frontend_atsc_c)\n  * [",
LANGPREF N_("ISDB-C"),
"](class/linuxdvb_frontend_isdb_c)\n\n##### ",
LANGPREF N_("SAT>IP (DVB-T/ATSC-T/ATSC-C/DVB-S)"),
"\n\n* [",
LANGPREF N_("Client"),
"](class/satip_client)\n* ",
LANGPREF N_("Frontend"),
"\n  * [",
LANGPREF N_("ATSC-T"),
"](class/satip_frontend_atsc_t)\n  * [",
LANGPREF N_("ATSC-C"),
"](class/satip_frontend_atsc_c)\n  * [",
LANGPREF N_("DVB-T"),
"](class/satip_frontend_dvbt)\n  * [",
LANGPREF N_("DVB-S (Master)"),
"](class/satip_frontend_dvbs)\n  * [",
LANGPREF N_("DVB-S (Slave)"),
"](class/satip_frontend_dvbs_slave)\n* [",
LANGPREF N_("Satellite Configuration"),
"](class/satip_satconf)\n\n---\n",

NULL
};

const char *tvh_doc_root_url[] = {
"### ",
LANGPREF N_("URL syntax"),
"\n\n",
LANGPREF N_("Please, add `http://IP:Port` to complete the URL."),
"\n\n#### ",
LANGPREF N_("/play/REMAIN"),
"\n\n",
LANGPREF N_("Return the playlist in _xspf_ or _m3u_ format. If the agent is in the list of direct agents (like wget/curl/vlc), the stream is returned instead."),
"\n\n",
LANGPREF N_("The remain part can be any URL starting with /stream ."),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Explanation"),
"\n----- | -----\n",
LANGPREF N_("playlist"),
" | ",
LANGPREF N_("Playlist type, can be"),
" _",
LANGPREF N_("xspf"),
"_  ",
LANGPREF N_("or"),
" _",
LANGPREF N_("m3u"),
"_ \n\n",
LANGPREF N_("__Example:__ `http://127.0.0.1:9981/play/stream/channelname/Life?playlist=xspf`"),
"\n\n#### ",
LANGPREF N_("/playlist[/TYPE][/WHAT][/IDENTIFIER]"),
"\n\n",
LANGPREF N_("Return the m3u playlist in Enigma2 format. By default (if the rest of path is ommitted), an redirection answer will be sent where /channels remainder is used."),
"\n\n",
LANGPREF N_("TYPE"),
" | ",
LANGPREF N_("Playlist type"),
"\n----- | -----\n_",
LANGPREF N_("empty"),
"_  | ",
LANGPREF N_("M3U"),
"\n",
LANGPREF N_("e2"),
" | ",
LANGPREF N_("Enigma2"),
"\n",
LANGPREF N_("satip"),
" | ",
LANGPREF N_("M3U using SAT>IP extensions"),
"\n\n",
LANGPREF N_("WHAT"),
" | ",
LANGPREF N_("Playlist contents"),
"\n----- | -----\n",
LANGPREF N_("channels"),
" | ",
LANGPREF N_("All channels"),
"\n",
LANGPREF N_("tags"),
" | ",
LANGPREF N_("All tags, for Enigma2 - tags are converted to labels"),
"\n",
LANGPREF N_("recordings"),
" | ",
LANGPREF N_("All recordings"),
"\n",
LANGPREF N_("channelnumber"),
" | ",
LANGPREF N_("One channel specified by channel number"),
"\n",
LANGPREF N_("channelname"),
" | ",
LANGPREF N_("One channel specified by channel name"),
"\n",
LANGPREF N_("channelid"),
" | ",
LANGPREF N_("One channel specified by short channel ID"),
"\n",
LANGPREF N_("tag"),
" | ",
LANGPREF N_("Tagged channels specified by UUID or tag name"),
"\n",
LANGPREF N_("tagname"),
" | ",
LANGPREF N_("Tagged channels specified by tag name"),
"\n",
LANGPREF N_("tagid"),
" | ",
LANGPREF N_("Tagged channels specified by short tag ID"),
"\n",
LANGPREF N_("dvrid"),
" | ",
LANGPREF N_("One DVR record specified by short DVR ID"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Explanation"),
"\n----- | -----\n",
LANGPREF N_("profile"),
" | ",
LANGPREF N_("Override streaming profile, otherwise the default profile for the user is used."),
"\n",
LANGPREF N_("sort"),
" | ",
LANGPREF N_("Sorting method"),
"\n\n",
LANGPREF N_("Sorting method"),
" | ",
LANGPREF N_("Scope"),
" | ",
LANGPREF N_("Description"),
"\n----- | ----- | -----\n",
LANGPREF N_("numname"),
" | ",
LANGPREF N_("channel"),
" | ",
LANGPREF N_("Channel number as first key, channel name as second key"),
"\n",
LANGPREF N_("name"),
" | ",
LANGPREF N_("channel"),
" | ",
LANGPREF N_("Channel name only"),
"\n",
LANGPREF N_("idxname"),
" | ",
LANGPREF N_("tag"),
" | ",
LANGPREF N_("Tag index as first key, tag name as second key"),
"\n",
LANGPREF N_("name"),
" | ",
LANGPREF N_("tag"),
" | ",
LANGPREF N_("Tag name only"),
"\n\n#### ",
LANGPREF N_("/stream/WHAT/IDENTIFIER"),
"\n\n",
LANGPREF N_("This URL scheme is used for streaming. The stream contents depends on the streaming profile. It might be MPEG-TS, Matroska or MP4."),
"\n\n",
LANGPREF N_("WHAT"),
" | ",
LANGPREF N_("Stream for"),
"\n----- | -----\n",
LANGPREF N_("channelnumber"),
" | ",
LANGPREF N_("Channel specified by channel number"),
"\n",
LANGPREF N_("channelname"),
" | ",
LANGPREF N_("Channel specified by channel name"),
"\n",
LANGPREF N_("channel"),
" | ",
LANGPREF N_("Channel specified by channel UUID"),
"\n",
LANGPREF N_("channelid"),
" | ",
LANGPREF N_("Channel specified by short channel ID"),
"\n",
LANGPREF N_("service"),
" | ",
LANGPREF N_("Service specified by service UUID"),
"\n",
LANGPREF N_("mux"),
" | ",
LANGPREF N_("Mux specified by mux UUID"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Explanation"),
"\n----- | -----\n",
LANGPREF N_("profile"),
" | ",
LANGPREF N_("(except /mux) Override streaming profile"),
"\n",
LANGPREF N_("weight"),
" | ",
LANGPREF N_("Override subscription weight"),
"\n",
LANGPREF N_("qsize"),
" | ",
LANGPREF N_("Override queue size in bytes (default value is 1500000 for channel/service, 10000000 for mux)"),
"\n",
LANGPREF N_("descramble"),
" | ",
LANGPREF N_("(/service only) do not descramble (if set to 0)"),
"\n",
LANGPREF N_("emm"),
" | ",
LANGPREF N_("(/service only) pass EMM to the stream (if set to 1)"),
"\n",
LANGPREF N_("pids"),
" | ",
LANGPREF N_("(/mux only) list of subscribed PIDs (comma separated)"),
"\n\n#### ",
LANGPREF N_("/xmltv[/WHAT][/IDENTIFIER]"),
"\n\n",
LANGPREF N_("Return the XMLTV EPG export. By default (if the rest of path is ommitted), an redirection answer will be sent where /channels remainder is used."),
"\n\n",
LANGPREF N_("WHAT"),
" | ",
LANGPREF N_("Playlist contents"),
"\n----- | -----\n",
LANGPREF N_("channels"),
" | ",
LANGPREF N_("All channels"),
"\n",
LANGPREF N_("channelnumber"),
" | ",
LANGPREF N_("One channel specified by channel number"),
"\n",
LANGPREF N_("channelname"),
" | ",
LANGPREF N_("One channel specified by channel name"),
"\n",
LANGPREF N_("channelid"),
" | ",
LANGPREF N_("One channel specified by short channel ID"),
"\n",
LANGPREF N_("tag"),
" | ",
LANGPREF N_("Tagged channels specified by UUID or tag name"),
"\n",
LANGPREF N_("tagname"),
" | ",
LANGPREF N_("Tagged channels specified by tag name"),
"\n",
LANGPREF N_("tagid"),
" | ",
LANGPREF N_("Tagged channels specified by short tag ID"),
"\n",

NULL
};

const char *tvh_doc_root_webui_about[] = {
"### ",
LANGPREF N_("About"),
"\n\n",
LANGPREF N_("This page displays general information about the current Tvheadend version."),
"\n\n",
LANGPREF N_("The build arguments/options used during compilation can be seen by clicking the _Toggle details_ link (only visible to users with admin rights)."),
"\n",

NULL
};

const char *tvh_doc_root_webui_general[] = {
"### ",
LANGPREF N_("General Overview of Web Interface"),
"\n\n",
LANGPREF N_("Tvheadend is operated primarily through a tabbed web interface."),
" \n\n",
LANGPREF N_("There are some basic navigation concepts that will help you get around and make the best of it."),
"\n\n#### ",
LANGPREF N_("Page Structure"),
"\n\n",
LANGPREF N_("The interface is made up of nested tabs, so similar functions are grouped together (e.g. all configuration items at the top level, then all configuration items for a particular topic are below that). However, be aware that not all tabs are shown by default, some tabs are hidden depending on the current"),
" [",
LANGPREF N_("view level"),
"](#view-level)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("Each tab is then typically laid out with a menu bar that provides access to Add/Save/Edit-type functions, and a grid like a spreadsheet below that. The grid items are frequently editable."),
"\n\n",
LANGPREF N_("Most configuration items - certainly the ones that are common to all types of item covered by that tab - are in this grid. However, some item-specific configuration items are then only available through the _Add_ and _Edit_ dialog boxes. For example, the main network configuration tab grid covers parameters common to DVB-S, -T, -C and IPTV networks, but specific things such as FEC rolloff or mux URL are then only in the dialogs for networks that need these values."),
"\n\n##### ",
LANGPREF N_("View level"),
"\n\n",
LANGPREF N_("The _View level_ drop-down/button - next to the Help button, displays/hides the more advanced features. By default it is set to Basic."),
"\n\n",
LANGPREF N_("View level"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Basic"),
"__  | ",
LANGPREF N_("Display the most commonly used tabs/items."),
"\n__",
LANGPREF N_("Advanced"),
"__  | ",
LANGPREF N_("Display the more advanced tabs/items."),
"\n__",
LANGPREF N_("Expert"),
"__  | ",
LANGPREF N_("Show all tabs/items."),
"\n\n",
LANGPREF N_("Depending on configuration, the view-level drop-down is not always visible."),
"\n\n#### ",
LANGPREF N_("Displaying and Manipulating Columns"),
"\n\n* ",
LANGPREF N_("Not all columns are necessarily visible. If you hover your mouse over a column heading, you'll see a down arrow - click here, and a drop-down menu will appear to give you access to __which columns are shown and which are not__ ."),
"\n* ",
LANGPREF N_("The same drop-down menu gives you access to a __sort__ function if defined (it doesn't always make sense to have a sortable column for some parameters). You can also sort a column by simply clicking on the column header; reverse the sort order by clicking again."),
"\n* ",
LANGPREF N_("And the same drop-down menu also gives you access to a __filter__ function if defined. The filter does simple pattern-matching on any string you provide. A small blue flag or triangle will appear in the top-left corner to indicate that a filter is active."),
"\n* ",
LANGPREF N_("__Re-arrange__ the columns by simply dragging he header to a new spot."),
"\n* ",
LANGPREF N_("__Re-size__ the columns by dragging the very edges of the column header as required."),
" \n* ",
LANGPREF N_("A cookie is used to remember your column/filtering preferences. Clearing your cookies will reset the interface to default."),
"\n\n#### ",
LANGPREF N_("Adding, Editing and More"),
"\n\n* ",
LANGPREF N_("Rows (in the grid) are multi-selectable, so you can carry out certain actions on more than one entry at the same time. So, for example, you can select multiple items by using ctrl+click on each entry or click, shift+click to select a range, or ctrl+A to select all."),
"\n* ",
LANGPREF N_("To add an entry, click the _Add_ button from the menu bar. You'll then see a dialog, or in some cases (where a list/split panel is used), a parameter panel. You can now fill in the desired/required fields, the entry can then be saved (_Create/Save_ button), applied (_Apply_ button), or abandoned (_Cancel_ button)."),
"\n* ",
LANGPREF N_("To edit a single entry in the grid, double click on the desired field/cell. It should now be editable. Once you've made your changes you can then save (_Save_ button), apply (_Apply_ button), or abandon (_Cancel_ button)."),
"\n  ",
LANGPREF N_("After a cell is changed, a small red flag or triangle will appear in the top-left corner to indicate that it has been changed."),
"\n  ",
LANGPREF N_("To change a check box or radio button, click once."),
"\n* ",
LANGPREF N_("To edit multiple entries, select the desired entries (as explained above), and then press the _Edit_ button - a dialog will be displayed. You can now make your changes to each field. These changes can then be kept (_Save_ button), applied (_Apply_ button), or abandoned (_Undo_ button). Remember to tick the check box before each field when saving/applying, so that the changes are applied to all selected entries."),
"\n* ",
LANGPREF N_("To delete entries, simply select the entry/entries and press the _Delete_ button. You will be prompted to confirm deletion."),
"\n",

NULL
};

const char *tvh_doc_root_inc_common_button_table_end[] = {
LANGPREF N_("__View Level__ | Change the interface view level to show/hide more advanced options.\n__Help__ | Display this help page."),
"\n",

NULL
};

const char *tvh_doc_root_inc_common_button_table_start[] = {
"#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the grid/entries."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert any changes made since the last save."),
"\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Display the"),
" _",
LANGPREF N_("Add entry"),
"_  ",
LANGPREF N_("dialog."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete the selected entry/entries."),
"\n__",
LANGPREF N_("Edit"),
"__  | ",
LANGPREF N_("Edit the selected entries."),
"\n",

NULL
};

const char *tvh_doc_root_inc_paging_tip[] = {
LANGPREF N_("\n__Tip__ : By default Tvheadend will only show a small selection of entries - you can increase the number of entries displayed by using the paging selector at the bottom right of the page."),
"\n",

NULL
};

const char *tvh_doc_root_inc_play[] = {
"#### ",
LANGPREF N_("Playing a Stream/File"),
"\n\n",
LANGPREF N_("You can play a stream/file by clicking the play icon !"),
"[",
LANGPREF N_("'Play Icon Image'"),
"](static/icons/control_play.png)",
LANGPREF N_(". This will automatically launch an appropriate player, otherwise you will need to manually open the playlist to start watching (normally a double-click on the downloaded file)."),
"\n\n",
LANGPREF N_("Note that the links don't link to the actual stream but to a playlist for use with media players such as VLC, If you'd prefer to receive the raw stream instead, you can do so by removing the `/play/` path from the URL - see"),
" [",
LANGPREF N_("URL Syntax"),
"](url) ",
LANGPREF N_("for more info."),
"\n",

NULL
};

const char *tvh_doc_access_entry_class[] = {
LANGPREF N_("Setting up access control is an important initial step as __the system is initially wide open__ ."),
" \n\n",
LANGPREF N_("Tvheadend verifies access by scanning through all enabled access control entries in sequence, from the top of the list to the bottom. The permission flags, streaming profiles, DVR config profiles, channel tags, and channel number ranges are combined for all matching access entries. You can control which parameters are merged (on a per-entry basis), see _Change parameters_"),
"  [",
LANGPREF N_("below"),
"](#items) ",
LANGPREF N_("for details."),
" \n\n",
LANGPREF N_("An access entry is said to match if the username and the IP source address of the requesting peer is within the prefix (_Allowed networks_ ). Wildcard ("),
"[",
LANGPREF N_("anonymous"),
"](#anonymous-access)",
LANGPREF N_(") accounts are matched using the prefix only."),
"\n\n",
LANGPREF N_("_The order of entries is __extremely__ important!_ It's recommended that you put the wildcard (asterisk `*`) accounts at top and all other accounts (with special permissions) at the bottom."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Access Entries Grid'"),
"](static/img/doc/access_entry/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("Entries are checked in order (when logging in, etc), the following functions allow you to change the ordering:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Move Up"),
"__  | ",
LANGPREF N_("Move the selected entry up the grid."),
"\n__",
LANGPREF N_("Move Down"),
"__  | ",
LANGPREF N_("Move the selected entry down the grid."),
" \n\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("This is an example of a limited user entry."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Access Entry Example'"),
"](static/img/doc/access_entry/new.png)\n\n",
LANGPREF N_("Remember to also add a password entry in the _"),
"[",
LANGPREF N_("Passwords"),
"](class/passwd)",
LANGPREF N_("_ tab - not required for wildcard accounts."),
" \n\n",
LANGPREF N_("__Tips__ :"),
"\n\n* ",
LANGPREF N_("Be as limiting as possible especially when making Tvheadend available over the Internet."),
"\n* ",
LANGPREF N_("For extra security always enter (a comma-separated list of) network prefix(es) (_Allowed networks_ )."),
"\n* ",
LANGPREF N_("You can have multiple entries using the same username with varying rights, allowing you to enable / disable each as needed. Note, matching (enabled) accounts will have permissions combined."),
"\n\n---\n\n#### ",
LANGPREF N_("Emergency/Backdoor Access"),
"\n\n",
LANGPREF N_("Tvheadend includes functionality that allows you to regain access to your Tvheadend instance in case of emergency or if you find yourself locked out, this is known as a superuser account. On some systems you may been asked to enter a superuser username and password during installation."),
"\n\n",
LANGPREF N_("To create a superuser account you must have access to your Tvheadend configuration directory (most commonly `$HOME/.hts/tvheadend`) and be able to create a plain-text file named `superuser` with the following (JSON formatted) content:"),
"\n```no-highlight\n{\n\"username\": \"superuser\",\n\"password\": \"superpassword\"\n}\n```\n\n",
LANGPREF N_("Once you've created this file you must restart Tvheadend for it to take affect. Note that for security the superuser account is not listed in the access entries grid."),
"\n\n",
LANGPREF N_("__Tip__ : Remember to set the correct permissions so that Tvheadend is able to read the superuser file."),
"\n\n---\n\n#### ",
LANGPREF N_("Anonymous Access"),
"\n\n",
LANGPREF N_("If you would like to allow anonymous access to your Tvheadend server you may set-up a wildcard account, you can do this by creating a new user and entering an asterisk `*` in the username field."),
"\n\n",
LANGPREF N_("__WARNING__ : Permissions given to a wildcard account apply to __all__ accounts."),
"\n\n---\n",

NULL
};

const char *tvh_doc_bouquet_class[] = {
LANGPREF N_("Bouquets are broadcaster-defined groupings and orders of channels."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Bouqets' Tab"),
"](static/img/doc/bouquet/tab.png)\n\n",
LANGPREF N_("To use bouquets, ensure to add and scan all available muxes using the predefined muxes or manual configuration."),
"\n\n",
LANGPREF N_("Bouquets are usually obtained automatically from the DVB source during the mux scan period. Note that bouquets may use more muxes and only services from scanned muxes are added. The mux with bouquets might require another scan when all muxes are discovered (manually using the rescan checkbox)."),
"\n\n",
LANGPREF N_("The fastscan bouquets are pre-defined in the configuration tree. These bouquets must be manually enabled to let Tvheadend to subscribe and listen to the specific MPEG-TS PIDs."),
"\n\n",
LANGPREF N_("You may import your own bouquet using enigma2 (.tv) formatted files."),
"\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("The following tab specific buttons are available:"),
" \n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Force Scan"),
"__  | ",
LANGPREF N_("Rescan the selected mux for changes to the bouquet."),
"\n\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Add Bouquet Dialog'"),
"](static/img/doc/bouquet/add.png)\n\n",
LANGPREF N_("Note that the URL must begin with `file://` or `http(s)://`."),
"\n\n---\n\n#### ",
LANGPREF N_("Detaching Channels"),
"\n\n",
LANGPREF N_("If you're mapping another service to a channel created by a bouquet you must first detach the channel to prevent unexpected changes, you can do this by selecting the desired channels from within the grid and then pressing the _Detach selected channels from bouquet_ option from the _[Map services]_ button."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Map All Services'"),
"](static/img/doc/bouquet/detach.png)\n\n",
LANGPREF N_("If you do not detach channel(s) before mapping additional services the following changes can occur.."),
"\n\n* ",
LANGPREF N_("The last mapped service's values will override the channel values set by the bouquet, e,g, if service \"MyTV\" with channel number 155 gets mapped to the channel \"BBC One\" on channel number 1 it will be renamed \"MyTV\" with channel number 155."),
"\n* ",
LANGPREF N_("Any changes (mapped services, number changes etc) to the channels can be lost if new changes in the bouquet override them."),
"\n\n",
LANGPREF N_("Detaching channels from a bouquet will prevent any further updates provided by the bouquet, which unfortunately means you will have to manually re-map when changes to services occur (e.g, mux moves, ceased broadcasting etc)."),
"\n\n---\n",

NULL
};

const char *tvh_doc_caclient_class[] = {
LANGPREF N_("Tvheadend supports connecting to card clients via the cwc (newcamd) and capmt (linux network dvbapi) protocols for so-called 'softcam' descrambling."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'CA Client Configuration Example'"),
"](static/img/doc/caclient/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the CA client configuration."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Undo any changes made to the CA client configuration since the last save."),
"\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Add a new CA client configuration."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete an existing CA client configuration."),
"\n__",
LANGPREF N_("Clone"),
"__  | ",
LANGPREF N_("Clone the currently selected configuration."),
"\n__",
LANGPREF N_("Move Up"),
"__  | ",
LANGPREF N_("Move the selected CA client configuration up in the list."),
"\n__",
LANGPREF N_("Move Down"),
"__  | ",
LANGPREF N_("Move the selected CA client configuration down in the list."),
"\n__",
LANGPREF N_("Show/Hide Passwords"),
"__  | ",
LANGPREF N_("Reveal/Hide any stored CA client passwords."),
"\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Available CA types"),
"\n\n",
LANGPREF N_("The following configuration parameters are used, depending on the type of CA access:"),
"\n\n* ",
LANGPREF N_("List of types"),
"\n  * [",
LANGPREF N_("CAPMT (Linux Network DVBAPI)"),
"](class/caclient_capmt)\n  * [",
LANGPREF N_("Code word client (newcamd)"),
"](class/caclient_cwc)\n  * [",
LANGPREF N_("DES constant code word client"),
"](class/caclient_ccw_des)\n  * [",
LANGPREF N_("AES constant code word client"),
"](class/caclient_ccw_aes)\n\n---\n\n#### ",
LANGPREF N_("Connection Status"),
"\n\n",
LANGPREF N_("The icon next to each entry within the grid indicates the client's connection status."),
"\n\n",
LANGPREF N_("Icon"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n![",
LANGPREF N_("'Accept/OK Icon'"),
"](icons/accept.png) | ",
LANGPREF N_("The client is connected."),
"\n![",
LANGPREF N_("'Error Icon'"),
"](icons/exclamation.png) | ",
LANGPREF N_("There was an error."),
"\n![",
LANGPREF N_("'Stop/Disabled Icon'"),
"](icons/stop.png) | ",
LANGPREF N_("The client is disabled."),
"\n\n---\n",

NULL
};

const char *tvh_doc_caclient_capmt_class[] = {
LANGPREF N_("Tvheadend supports connecting to card clients via the cwc (newcamd) and capmt (linux network dvbapi) protocols for so-called 'softcam' descrambling."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Channel tag'"),
"](static/img/doc/caclient_capmt/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the CA client configuration."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Undo any changes made to the CA client configuration since the last save."),
"\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Add a new CA client configuration."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete an existing CA client configuration."),
"\n__",
LANGPREF N_("Clone"),
"__  | ",
LANGPREF N_("Clone the currently selected configuration."),
"\n__",
LANGPREF N_("Move Up"),
"__  | ",
LANGPREF N_("Move the selected CA client configuration up in the list."),
"\n__",
LANGPREF N_("Move Down"),
"__  | ",
LANGPREF N_("Move the selected CA client configuration down in the list."),
"\n__",
LANGPREF N_("Show/Hide Passwords"),
"__  | ",
LANGPREF N_("Reveal/Hide any stored CA client passwords."),
"\n__",
LANGPREF N_("Help"),
"__  | ",
LANGPREF N_("Display this help page."),
"\n\n---\n\n#### ",
LANGPREF N_("Connection Status"),
"\n\n",
LANGPREF N_("The icon next to each entry within the grid indicates the client's connection status."),
"\n\n",
LANGPREF N_("Icon"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n![",
LANGPREF N_("'Accept/OK Icon'"),
"](icons/accept.png) | ",
LANGPREF N_("The client is connected."),
"\n![",
LANGPREF N_("'Error Icon'"),
"](icons/exclamation.png) | ",
LANGPREF N_("There was an error."),
"\n![",
LANGPREF N_("'Stop/Disabled Icon'"),
"](icons/stop.png) | ",
LANGPREF N_("The client is disabled."),
"\n\n---\n\n#### ",
LANGPREF N_("Modes"),
"\n\n##### ",
LANGPREF N_("OSCam net protocol (rev >= 10389)"),
"\n\n",
LANGPREF N_("__This is the most preferred mode for the latest OSCam.__ It supports the latest features like ECM status."),
"\n\n",
LANGPREF N_("A TCP connection to the server is created. All EMM/ECM data is sent to OSCam using this connection without the need for real linuxdvb devices to be present in the system. This mode is suitable for all DVB devices including SAT>IP and IPTV."),
"\n\n",
LANGPREF N_("If you run your OSCam server on the same machine as TVHeadend, set _Camd.socket filename / IP Address (TCP mode)_ field to 127.0.0.1 and _Listen / Connect port_ to 9000 (or your preferred TCP port). Note that the TCP port must match OSCam's configuration."),
"\n\n",
LANGPREF N_("The following lines are required in __[dvbapi]__ section of oscam.conf:"),
"\n```no-highlight\nboxtype = pc\npmt_mode = 4\nlisten_port = 9000 # or your preferred port\n```\n\n##### ",
LANGPREF N_("OSCam new pc-nodmx (rev >= 10389)"),
"\n\n",
LANGPREF N_("Similar to _OSCam net protocol (rev >= 10389)_ mode, but a named pipe (/tmp/camd.socket) connection is used instead of the TCP connection."),
"\n\n##### ",
LANGPREF N_("OSCam TCP (rev >= 9574)"),
"\n\n",
LANGPREF N_("A TCP connection to the server is created. All EMM/ECM data is sent to OSCam using this connection without the need for real linuxdvb devices to be present in the system. This mode is suitable for all DVB devices including SAT>IP and IPTV."),
"\n\n",
LANGPREF N_("The following lines are required in __[dvbapi]__ section of oscam.conf:"),
"\n```no-highlight\nboxtype = pc\npmt_mode = 4\nlisten_port = 9000 # or your preferred port\n```\n\n##### ",
LANGPREF N_("OSCam pc-nodmx (rev >= 9756)"),
"\n\n",
LANGPREF N_("Similar to _OSCAM TCP (rev >= 9574)_ mode, but a named pipe (/tmp/camd.socket) connection is used instead of the TCP connection."),
"\n\n##### ",
LANGPREF N_("OSCam (rev >= 9095)"),
"\n\n",
LANGPREF N_("This mode uses named pipe (/tmp/camd.socket)."),
"\n\n",
LANGPREF N_("The difference between _Older OSCam_ mode is that no UDP connections are required. All communication is processed through the named pipe (/tmp/camd.socket). The configuration for OSCam is same as the previous _Older OSCam_ mode."),
"\n\n##### ",
LANGPREF N_("Older OSCam"),
"\n\n",
LANGPREF N_("This mode uses named pipe (/tmp/camd.socket)."),
"\n\n",
LANGPREF N_("If selected, connection will be made directly to OSCam without using the LD_PRELOAD / wrapper hack. TVH listens on a range of UDP ports starting with the specified port number (standard port range starts with 9000)."),
"\n\n",
LANGPREF N_("The following lines are required in __[dvbapi]__ section of oscam.conf:"),
"\n```no-highlight\nboxtype = pc\npmt_mode = 4\n```\n\n##### ",
LANGPREF N_("Wrapper (capmt_ca.so)"),
"\n\n",
LANGPREF N_("This mode uses named pipe (/tmp/camd.socket)."),
"\n\n",
LANGPREF N_("With the LD_PRELOAD / wrapper hack active. TVH listens on the local specified UDP port (standard is 9000) for the code words. Only one channel can be decoded at a time."),
"\n\n---\n",

NULL
};

const char *tvh_doc_channel_class[] = {
LANGPREF N_("This tab lists all defined channels."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Channel lists'"),
"](static/img/doc/channel/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("The following tab specific functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Reset Icon"),
"__  | ",
LANGPREF N_("Reset the selected channel(s)"),
" _",
LANGPREF N_("User Icon"),
"_  ",
LANGPREF N_("/"),
" _",
LANGPREF N_("Icon URL"),
"_ ",
LANGPREF N_(", especially useful if you change your Picon settings."),
" \n__",
LANGPREF N_("Map Services"),
"__  | ",
LANGPREF N_("Drop down menu (see mapping button table below)."),
" \n__",
LANGPREF N_("Number Operations"),
"__  | ",
LANGPREF N_("Drop down menu (see numbering button table below)."),
"\n\n",
LANGPREF N_("Mapping Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Map services"),
"__  | ",
LANGPREF N_("Map"),
" [",
LANGPREF N_("services"),
"](class/mpegts_service)",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Map all services"),
"__  | ",
LANGPREF N_("Map all available"),
" [",
LANGPREF N_("services"),
"](class/mpegts_service) ",
LANGPREF N_("as channels"),
"\n\n",
LANGPREF N_("Numbering Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Assign Number"),
"__  | ",
LANGPREF N_("Assign the lowest available channel number(s) to the selected channel(s)."),
"\n__",
LANGPREF N_("Number Up"),
"__  | ",
LANGPREF N_("Increment the selected channel number(s) by 1."),
" \n__",
LANGPREF N_("Number Down"),
"__  | ",
LANGPREF N_("Decrement the selected channel numbers by 1."),
" \n__",
LANGPREF N_("Swap Numbers"),
"__  | ",
LANGPREF N_("Swap the numbers of the"),
" __",
LANGPREF N_("two"),
"__  ",
LANGPREF N_("selected channels."),
"\n\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Add Channel Dialog'"),
"](static/img/doc/channel/add.png)\n\n",
LANGPREF N_("In the above example image, we're creating a channel called Channel 4 and mapping it to the service of the same name. You can name a channel whatever you like, it doesn't have to match the service it's linking to."),
" \n\n",
LANGPREF N_("If you have a lot of services you may want to use the"),
" [",
LANGPREF N_("Map services"),
"](class/mpegts_service)  ",
LANGPREF N_("functions or a"),
" [",
LANGPREF N_("Bouquet"),
"](class/bouquet)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("Note, that editing a channel created by a bouquet can have unexpected results, please see _Detaching Channels_ on the"),
" [",
LANGPREF N_("Bouquet"),
"](class/bouquet) ",
LANGPREF N_("page for info."),
"\n\n---\n",
MDINCLUDE "inc/play",
"\n---\n",

NULL
};

const char *tvh_doc_channeltag_class[] = {
LANGPREF N_("This tab is used to configure channel tags. Tags are used to define a set of channels - to group them, to aid searches, and similar. Tags are not required by Tvheadend itself, but are useful in media applications such as Kodi and are a requirement for using Tvheadend with Movian."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Channel tag'"),
"](static/img/doc/channeltag/tab.png)\n\n---\n",

NULL
};

const char *tvh_doc_config_class[] = {
LANGPREF N_("This tabs allow configuration of several general parameters that affect the core Tvheadend functionality."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'General Base' Tab Screenshot 1"),
"](static/img/doc/config/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Undo changes since the last save."),
"\n__",
LANGPREF N_("Start wizard"),
"__  | ",
LANGPREF N_("Display the first-run set-up wizard."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_debugging_class[] = {
LANGPREF N_("This tab is used to configure various debugging options in tvheadend."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Debugging tab'"),
"](static/img/doc/debugging/tab.png)\n\n",
LANGPREF N_("Changes to any of these settings must be confirmed by pressing the _[Apply configuration]_ button before taking effect."),
"\n\n",
LANGPREF N_("Note that settings are not saved to a storage. Any change is available only while Tvheadend is running, and will be lost on a restart. To change the default behaviour permanently, use command line options such as `-l,` `–debug`, `–trace`."),
"\n\n",
LANGPREF N_("Depending on your distribution, the default command-line configuration is usually stored in the `/etc/sysconfig` tree or an init script. You may also be able to change `/etc/default/tvheadend` to add additional command-line parameters."),
"\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Apply configuration (run-time only)"),
"__  | ",
LANGPREF N_("Apply the entered debugging settings."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Subsystems"),
"\n\n",
LANGPREF N_("The following options can be passed to tvheadend to provide detailed debugging information while the application is running."),
"\n\n",
LANGPREF N_("Subsystem"),
" | ",
LANGPREF N_("Name"),
"\n----- | -----\n  ",
LANGPREF N_("START"),
" | ",
LANGPREF N_("START"),
"\n  ",
LANGPREF N_("STOP"),
" | ",
LANGPREF N_("STOP"),
"\n  ",
LANGPREF N_("CRASH"),
" | ",
LANGPREF N_("CRASH"),
"\n  ",
LANGPREF N_("main"),
" | ",
LANGPREF N_("Main"),
"\n  ",
LANGPREF N_("gtimer"),
" | ",
LANGPREF N_("Global timer"),
"\n  ",
LANGPREF N_("mtimer"),
" | ",
LANGPREF N_("Monitonic timer"),
"\n  ",
LANGPREF N_("CPU"),
" | ",
LANGPREF N_("CPU"),
"\n  ",
LANGPREF N_("thread"),
" | ",
LANGPREF N_("Thread"),
"\n  ",
LANGPREF N_("tvhpoll"),
" | ",
LANGPREF N_("Poll multiplexer"),
"\n  ",
LANGPREF N_("time"),
" | ",
LANGPREF N_("Time"),
"\n  ",
LANGPREF N_("spawn"),
" | ",
LANGPREF N_("Spawn"),
"\n  ",
LANGPREF N_("fsmonitor"),
" | ",
LANGPREF N_("Filesystem monitor"),
"\n  ",
LANGPREF N_("lock"),
" | ",
LANGPREF N_("Locking"),
"\n  ",
LANGPREF N_("uuid"),
" | ",
LANGPREF N_("UUID"),
"\n  ",
LANGPREF N_("idnode"),
" | ",
LANGPREF N_("Node subsystem"),
"\n  ",
LANGPREF N_("url"),
" | ",
LANGPREF N_("URL"),
"\n  ",
LANGPREF N_("tcp"),
" | ",
LANGPREF N_("TCP Protocol"),
"\n  ",
LANGPREF N_("rtsp"),
" | ",
LANGPREF N_("RTSP Protocol"),
"\n  ",
LANGPREF N_("upnp"),
" | ",
LANGPREF N_("UPnP Protocol"),
"\n  ",
LANGPREF N_("settings"),
" | ",
LANGPREF N_("Settings"),
"\n  ",
LANGPREF N_("config"),
" | ",
LANGPREF N_("Configuration"),
"\n  ",
LANGPREF N_("access"),
" | ",
LANGPREF N_("Access (ACL)"),
"\n  ",
LANGPREF N_("cron"),
" | ",
LANGPREF N_("Cron"),
"\n  ",
LANGPREF N_("dbus"),
" | ",
LANGPREF N_("DBUS"),
"\n  ",
LANGPREF N_("avahi"),
" | ",
LANGPREF N_("Avahi"),
"\n  ",
LANGPREF N_("bonjour"),
" | ",
LANGPREF N_("Bonjour"),
"\n  ",
LANGPREF N_("api"),
" | ",
LANGPREF N_("API"),
"\n  ",
LANGPREF N_("http"),
" | ",
LANGPREF N_("HTTP Server"),
"\n  ",
LANGPREF N_("httpc"),
" | ",
LANGPREF N_("HTTP Client"),
"\n  ",
LANGPREF N_("htsp"),
" | ",
LANGPREF N_("HTSP Server"),
"\n  ",
LANGPREF N_("htsp-sub"),
" | ",
LANGPREF N_("HTSP Subscription"),
"\n  ",
LANGPREF N_("htsp-req"),
" | ",
LANGPREF N_("HTSP Request"),
"\n  ",
LANGPREF N_("htsp-ans"),
" | ",
LANGPREF N_("HTSP Answer"),
"\n  ",
LANGPREF N_("imagecache"),
" | ",
LANGPREF N_("Image Cache"),
"\n  ",
LANGPREF N_("tbl"),
" | ",
LANGPREF N_("DVB SI Tables"),
"\n  ",
LANGPREF N_("tbl-base"),
" | ",
LANGPREF N_("Base DVB SI Tables (PAT,CAT,PMT,SDT etc.)"),
"\n  ",
LANGPREF N_("tbl-csa"),
" | ",
LANGPREF N_("DVB CSA (descrambling) Tables"),
"\n  ",
LANGPREF N_("tbl-eit"),
" | ",
LANGPREF N_("DVB EPG Tables"),
"\n  ",
LANGPREF N_("tbl-time"),
" | ",
LANGPREF N_("DVB Time Tables"),
"\n  ",
LANGPREF N_("tbl-atsc"),
" | ",
LANGPREF N_("ATSC SI Tables"),
"\n  ",
LANGPREF N_("tbl-pass"),
" | ",
LANGPREF N_("Passthrough Muxer SI Tables"),
"\n  ",
LANGPREF N_("tbl-satip"),
" | ",
LANGPREF N_("SAT>IP Server SI Tables"),
"\n  ",
LANGPREF N_("fastscan"),
" | ",
LANGPREF N_("Fastscan DVB"),
"\n  ",
LANGPREF N_("parser"),
" | ",
LANGPREF N_("MPEG-TS Parser"),
"\n  ",
LANGPREF N_("TS"),
" | ",
LANGPREF N_("Transport Stream"),
"\n  ",
LANGPREF N_("globalheaders"),
" | ",
LANGPREF N_("Global Headers"),
"\n  ",
LANGPREF N_("tsfix"),
" | ",
LANGPREF N_("Time Stamp Fix"),
"\n  ",
LANGPREF N_("hevc"),
" | ",
LANGPREF N_("HEVC - H.265"),
"\n  ",
LANGPREF N_("muxer"),
" | ",
LANGPREF N_("Muxer"),
"\n  ",
LANGPREF N_("pass"),
" | ",
LANGPREF N_("Pass-thru muxer"),
"\n  ",
LANGPREF N_("mkv"),
" | ",
LANGPREF N_("Matroska muxer"),
"\n  ",
LANGPREF N_("service"),
" | ",
LANGPREF N_("Service"),
"\n  ",
LANGPREF N_("channel"),
" | ",
LANGPREF N_("Channel"),
"\n  ",
LANGPREF N_("subscription"),
" | ",
LANGPREF N_("Subscription"),
"\n  ",
LANGPREF N_("service-mapper"),
" | ",
LANGPREF N_("Service Mapper"),
"\n  ",
LANGPREF N_("bouquet"),
" | ",
LANGPREF N_("Bouquet"),
"\n  ",
LANGPREF N_("esfilter"),
" | ",
LANGPREF N_("Elementary Stream Filter"),
"\n  ",
LANGPREF N_("profile"),
" | ",
LANGPREF N_("Streaming Profile"),
"\n  ",
LANGPREF N_("descrambler"),
" | ",
LANGPREF N_("Descrambler"),
"\n  ",
LANGPREF N_("caclient"),
" | ",
LANGPREF N_("CA (descrambling) Client"),
"\n  ",
LANGPREF N_("csa"),
" | ",
LANGPREF N_("CSA (descrambling)"),
"\n  ",
LANGPREF N_("capmt"),
" | ",
LANGPREF N_("CAPMT CA Client"),
"\n  ",
LANGPREF N_("cwc"),
" | ",
LANGPREF N_("CWC CA Client"),
"\n  ",
LANGPREF N_("dvbcam"),
" | ",
LANGPREF N_("DVB CAM Client"),
"\n  ",
LANGPREF N_("dvr"),
" | ",
LANGPREF N_("Digital Video Recorder"),
"\n  ",
LANGPREF N_("epg"),
" | ",
LANGPREF N_("Electronic Program Guide"),
"\n  ",
LANGPREF N_("epgdb"),
" | ",
LANGPREF N_("EPG Database"),
"\n  ",
LANGPREF N_("epggrab"),
" | ",
LANGPREF N_("EPG Grabber"),
"\n  ",
LANGPREF N_("charset"),
" | ",
LANGPREF N_("Charset"),
"\n  ",
LANGPREF N_("dvb"),
" | ",
LANGPREF N_("DVB"),
"\n  ",
LANGPREF N_("mpegts"),
" | ",
LANGPREF N_("MPEG-TS"),
"\n  ",
LANGPREF N_("muxsched"),
" | ",
LANGPREF N_("Mux Scheduler"),
"\n  ",
LANGPREF N_("libav"),
" | ",
LANGPREF N_("libav / ffmpeg"),
"\n  ",
LANGPREF N_("transcode"),
" | ",
LANGPREF N_("Transcode"),
"\n  ",
LANGPREF N_("iptv"),
" | ",
LANGPREF N_("IPTV"),
"\n  ",
LANGPREF N_("iptv-pcr"),
" | ",
LANGPREF N_("IPTV PCR"),
"\n  ",
LANGPREF N_("linuxdvb"),
" | ",
LANGPREF N_("LinuxDVB Input"),
"\n  ",
LANGPREF N_("diseqc"),
" | ",
LANGPREF N_("DiseqC"),
"\n  ",
LANGPREF N_("en50221"),
" | ",
LANGPREF N_("CI Module"),
"\n  ",
LANGPREF N_("en50494"),
" | ",
LANGPREF N_("Unicable (EN50494)"),
"\n  ",
LANGPREF N_("satip"),
" | ",
LANGPREF N_("SAT>IP Client"),
"\n  ",
LANGPREF N_("satips"),
" | ",
LANGPREF N_("SAT>IP Server"),
"\n  ",
LANGPREF N_("tvhdhomerun"),
" | ",
LANGPREF N_("TVHDHomeRun Client"),
"\n  ",
LANGPREF N_("psip"),
" | ",
LANGPREF N_("ATSC PSIP EPG"),
"\n  ",
LANGPREF N_("opentv"),
" | ",
LANGPREF N_("OpenTV EPG"),
"\n  ",
LANGPREF N_("pyepg"),
" | ",
LANGPREF N_("PyEPG Import"),
"\n  ",
LANGPREF N_("xmltv"),
" | ",
LANGPREF N_("XMLTV EPG Import"),
"\n  ",
LANGPREF N_("webui"),
" | ",
LANGPREF N_("Web User Interface"),
"\n  ",
LANGPREF N_("timeshift"),
" | ",
LANGPREF N_("Timeshift"),
"\n  ",
LANGPREF N_("scanfile"),
" | ",
LANGPREF N_("Scanfile"),
"\n  ",
LANGPREF N_("tsfile"),
" | ",
LANGPREF N_("MPEG-TS File"),
"\n\n---\n",

NULL
};

const char *tvh_doc_dvrautorec_class[] = {
LANGPREF N_("This tab controls EPG-driven recording rules."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Autorec' Tab"),
"](static/img/doc/dvrautorec/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("If you wanted to record any programs matching \"BBC News\" on BBC One you would enter something like this into the add entry dialog:"),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Autorec example entry'"),
"](static/img/doc/dvrautorec/add.png)\n\n",
LANGPREF N_("This uses a regular expression (regex) to match the program title \"BBC News\" exactly, otherwise event titles containing the phrase would also match, e.g \"BBC News at One\" and \"BBC News at Six\" etc."),
"\n\n",
LANGPREF N_("Regular expressions examples:"),
"\n\n",
LANGPREF N_("Regex"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n ",
"`^BBC News$` | ",
LANGPREF N_("Matches \"BBC News\" exactly."),
"\n ",
"`^(New\\: )?Regular Show$` | ",
LANGPREF N_("Matches \"Regular Show\" and (if it exists) \"New: Regular Show\"."),
"\n\n",
LANGPREF N_("Matching events will be added to the _"),
"[",
LANGPREF N_("Upcoming/Current Recordings"),
"](class/dvrentry)",
LANGPREF N_("_ tab. __Note that if your rule matches any in-progress events they will automatically start being recorded.__"),
" \n\n---\n",

NULL
};

const char *tvh_doc_dvrconfig_class[] = {
LANGPREF N_("This tab is used to configure operation of the Digital Video Recorder. It is not used for scheduling or administration of individual recordings."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Digital Video Recorder Profiles' Tab 1"),
"](static/img/doc/dvrconfig/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the selected profile."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Undo any changes made to the selected profile since the last save."),
"\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Add a new profile."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete an existing profile."),
"\n__",
LANGPREF N_("Clone"),
"__  | ",
LANGPREF N_("Clone the currently selected profile."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_dvrentry_class[] = {
LANGPREF N_("This tab is where you manage your recordings. Each entry is moved between the _Upcoming / Current Recordings_ , _Finished Recordings_ and _Failed Recordings_ sub-tabs depending on its status."),
"\n\n",
LANGPREF N_("__Upcoming / Current Recordings__ : This sub-tab lists current and upcoming recording entries. Entries shown here are either currently recording or are soon-to-be recorded."),
"\n\n",
LANGPREF N_("__Finished Recordings__ : This sub-tab lists all completed recording entries. Entries shown here have reached the end of the scheduled (or EITp/f defined) recording time."),
"\n\n",
LANGPREF N_("__Failed Recordings__ : This sub-tab lists all failed recording entries. Entries shown here have failed to record due to one (or more) errors that occurred during the recording."),
"\n\n",
LANGPREF N_("__Removed Recordings__ : This sub-tab lists all recording entries that have missing file(s). Entries shown here link to file(s) that Tvheadend cannot locate (files which have been externally removed)."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Digital Video Recorder' Tabs"),
"](static/img/doc/dvrentry/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available (tab dependant):"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Add a new (one-time-only) recording entry."),
"\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save changes made to the grid entries."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert all changes made to the grid entries since the last save."),
"\n__",
LANGPREF N_("Stop"),
"__  | ",
LANGPREF N_("Gracefully stop the selected in-progress recording entries."),
"\n__",
LANGPREF N_("Abort"),
"__  | ",
LANGPREF N_("Abruptly stop the selected in-progress recording entries."),
" \n__",
LANGPREF N_("Delete/Remove"),
"__  | ",
LANGPREF N_("Delete/Remove the selected grid entries."),
"\n__",
LANGPREF N_("Edit"),
"__  | ",
LANGPREF N_("Edit the selected grid entries."),
"\n__",
LANGPREF N_("Download"),
"__  | ",
LANGPREF N_("Download the recording."),
"\n__",
LANGPREF N_("Re-record"),
"__  | ",
LANGPREF N_("Re-schedule the selected entry/recording if possible."),
"\n__",
LANGPREF N_("Move to failed"),
"__  | ",
LANGPREF N_("Move the selected recording entries to the"),
" __",
LANGPREF N_("Failed Recordings"),
"__  ",
LANGPREF N_("tab."),
"\n__",
LANGPREF N_("Move to finished"),
"__  | ",
LANGPREF N_("Move the selected recording entries to the"),
" __",
LANGPREF N_("Finished Recordings"),
"__  ",
LANGPREF N_("tab."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Entry Overview"),
"\n\n",
LANGPREF N_("The _Details_ column gives a quick overview as to the status of each entry:"),
"\n\n",
LANGPREF N_("Icon"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n![",
LANGPREF N_("Clock icon"),
"](icons/scheduled.png) | ",
LANGPREF N_("the program is scheduled (upcoming)"),
"\n![",
LANGPREF N_("Recording icon"),
"](icons/rec.png) | ",
LANGPREF N_("recording of the program is active and underway (current)"),
"\n![",
LANGPREF N_("Information icon"),
"](icons/information.png) | ",
LANGPREF N_("click to display detailed information about the selected recording"),
"\n![",
LANGPREF N_("Exclamation icon"),
"](icons/exclamation.png) | ",
LANGPREF N_("the program failed to record"),
"\n![",
LANGPREF N_("Accept icon"),
"](icons/accept.png) | ",
LANGPREF N_("the program recorded successfully"),
"\n\n---\n\n#### ",
LANGPREF N_("Manual Recording Entry Example"),
"\n\n",
LANGPREF N_("This is an example of a one-time recording entry."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Add new recording dialog'"),
"](static/img/doc/dvrentry/add.png)\n\n#### ",
LANGPREF N_("Adding an Entry Using the EPG"),
"\n\n",
LANGPREF N_("Using the Electronic Program Guide search functionality, find the program/event you would like to record. Click on it, then using the broadcast details dialog you can:"),
"\n\n* ",
LANGPREF N_("Record the event once by pressing the _[Record program]_ button."),
"\n* ",
LANGPREF N_("Automatically record all upcoming events matching the program's title by pressing the _[Autorec]_ button."),
"\n* ",
LANGPREF N_("Record all upcoming series episodes by pressing the _[Record series]_ button. __This replaces the _[Autorec]_ button when series link information is available.__"),
" \n\n",
LANGPREF N_("For full instructions on how to search and record using the EPG take a look at the"),
" [",
LANGPREF N_("EPG"),
"](epg) ",
LANGPREF N_("page."),
"\n\n#### ",
LANGPREF N_("Adding an Entry Using Autorec Rules"),
"\n\n",
LANGPREF N_("Autorec rules allow you to match events using various options."),
" \n\n* ",
LANGPREF N_("Record events using regular expressions, they can be as simple or as powerful as you like."),
"\n* ",
LANGPREF N_("Record events that broadcast between certain times or days of the week."),
"\n\n",
LANGPREF N_("See"),
" [",
LANGPREF N_("Autorec"),
"](class/dvrautorec) ",
LANGPREF N_("for more information."),
"\n\n---\n\n#### ",
LANGPREF N_("Downloading a Recording"),
"\n\n",
LANGPREF N_("Highlight (select) the desired entry, then press the _[Download]_ button on the menu bar."),
"\n\n---\n\n#### ",
LANGPREF N_("Re-recording an Entry/Re-schedule a Recording"),
"\n\n",
LANGPREF N_("You can re-schedule an entry by pressing the _[Re-record]_ button on the menu bar."),
"\n\n",
LANGPREF N_("__Note__ : Your EPG data must have another matching event to be able to re-schedule the entry."),
"\n\n---\n",

NULL
};

const char *tvh_doc_dvrtimerec_class[] = {
LANGPREF N_("This tab controls timer-driven recording rules."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("Timer Tab"),
"](static/img/doc/dvrtimerec/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("This is an example of a one-time timer-based recording entry."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("Timer add example"),
"](static/img/doc/dvrtimerec/add.png)\n\n",
LANGPREF N_("Note that when you create a rule/entry it will also generate a"),
" [",
LANGPREF N_("DVR Entry"),
"](class/dvrentry)",
LANGPREF N_("."),
"\n\n---\n",

NULL
};

const char *tvh_doc_epgconf_class[] = {
LANGPREF N_("This tab is used to configure the Electronic Program Guide (EPG)"),
"  [",
LANGPREF N_("grabbing"),
"](class/epggrab_mod) ",
LANGPREF N_("capabilities."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'EPG Grabber Configuration'"),
"](static/img/doc/epgconf/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the tab."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert any changes made since the last save."),
"\n__",
LANGPREF N_("Trigger OTA EPG Grabber"),
"__  | ",
LANGPREF N_("Force an immediate tune to the OTA EPG mux(es) to request EPG updates."),
"\n__",
LANGPREF N_("Re-run Internal EPG Grabbers"),
"__  | ",
LANGPREF N_("Re-run all enabled"),
" [",
LANGPREF N_("grabbers"),
"](class/epggrab_mod)",
LANGPREF N_("."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_epggrabber_channel_class[] = {
LANGPREF N_("This tab displays EPG data used by channels."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'EPG Grabber Channels Tab'"),
"](static/img/doc/epggrabber_channel/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the grid."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert any changes made since the last save."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete the selected grid entries."),
"\n__",
LANGPREF N_("Edit"),
"__  | ",
LANGPREF N_("Edit the selected grid entries."),
"\n\n---\n",

NULL
};

const char *tvh_doc_epggrabber_modules_class[] = {
LANGPREF N_("This tab is used to configure the Electronic Program Guide (EPG) grabber modules. Tvheadend supports a variety of different EPG grabbing mechanisms. These fall into 3 broad categories, within which there are a variety of specific grabber implementations."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'EPG Grabber Configuration'"),
"](static/img/doc/epggrabber_modules/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the tab."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert any changes made since the last save."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Notes"),
"\n\n* ",
LANGPREF N_("Only OTA EIT and PSIP (ATSC) grabbers are enabled by default. If you're missing EPG data, make sure to enable the correct grabber(s) for your location/provider."),
"\n* ",
LANGPREF N_("If you use more than one grabber, be sure to give a higher priority to the grabber that provides you with richer data."),
"\n\n",
LANGPREF N_("__Tip__ : Don't forget to set the _EIT time offset_ for your network(s)."),
"\n\n---\n",

NULL
};

const char *tvh_doc_filters_class[] = {
LANGPREF N_("This tab allows you to define rules that filter and order various elementary streams."),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Stream filters'"),
"](static/img/doc/filters/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("Tab specific functions:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Move Up"),
"__  | ",
LANGPREF N_("Move the selected entry up the grid."),
"\n__",
LANGPREF N_("Move Down"),
"__  | ",
LANGPREF N_("Move the selected entry down the grid."),
" \n\n---\n\n#### ",
LANGPREF N_("Filter Basics"),
"\n\n* ",
LANGPREF N_("Each rule is executed in sequence (as displayed in the grid)."),
" \n* ",
LANGPREF N_("If a rule removes a stream, it will not be available to other rules unless explicitly added back in (by another rule)."),
"\n* ",
LANGPREF N_("Elementary streams not marked IGNORE, USE or EXCLUSIVE will not be filtered out."),
"\n* ",
LANGPREF N_("Rules with fields not defined (or set to _ANY_ ) will apply to ALL elementary streams. For example, not defining/selecting _ANY_ for the _Language_ field will apply the filter to all streams available/not already filtered out by another rule."),
"\n* ",
LANGPREF N_("USE / EMPTY rules have precedence against IGNORE (if the stream is already selected - it cannot be ignored)."),
"\n\n---\n\n#### ",
LANGPREF N_("Visual Verification of Filtering"),
"\n\n",
LANGPREF N_("For visual verification of filtering, there is the service info dialog in the"),
" [",
LANGPREF N_("Services"),
"](class/mpegts_service) ",
LANGPREF N_("tab. This dialog shows the received PIDs and filtered PIDs in one window."),
"\n\n---\n\n#### ",
LANGPREF N_("Filtering out a Stream"),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Removing a stream'"),
"](static/img/doc/filters/example.png)\n\n",
LANGPREF N_("Here we're removing the Bulgarian language audio from the input (first rule). However, if Bulgarian is the only language available add it back in as a last resort (second rule)."),
"\n\n#### ",
LANGPREF N_("Ignoring Unknown Streams"),
"\n\n",
LANGPREF N_("If you'd like to ignore unknown elementary streams, add a rule to the end of grid with the _ANY_ (not defined) comparison(s) and the action set to _IGNORE_ ."),
"\n\n---\n",

NULL
};

const char *tvh_doc_imagecache_class[] = {
LANGPREF N_("This will cache any channel icons or other images (such as EPG metadata) to be served from the local webserver. This can be useful for multi-client systems and, generally, to reduce hits on upstream providers."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Configuration - Image Cache tab'"),
"](static/img/doc/imagecache/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the tab."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert any changes made since the last save."),
"\n__",
LANGPREF N_("Clean image (icon) cache"),
"__  | ",
LANGPREF N_("Clean-up the stored image files (empty cache and re-fetch icons)."),
"\n__",
LANGPREF N_("Re-fetch images"),
"__  | ",
LANGPREF N_("Re-refresh image cache (reload images from upstream providers)."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_ipblocking_class[] = {
LANGPREF N_("This tab allows to configure blocked IP ranges. Users within these ranges are not allowed to login (use any Tvheadend service)."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Access Control - Entries tab'"),
"](static/img/doc/ipblocking/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_linuxdvb_frontend_class[] = {
LANGPREF N_("This is the list of available parameters for the linuxdvb frontend. It is used as a base for other frontends."),
"\n\n",
LANGPREF N_("See"),
" [",
LANGPREF N_("TV Adapters"),
"](tv_adapters)",
LANGPREF N_("."),
"\n\n---\n",

NULL
};

const char *tvh_doc_linuxdvb_frontend_dvbc_class[] = {
LANGPREF N_("This panel lists all the available Cable (DVB-C/C2/ISDB-C/ATSC-C) frontend parameters."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'DVB-C frontend parameters'"),
"](static/img/doc/linuxdvb_frontend_dvbc/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_linuxdvb_frontend_dvbs_class[] = {
LANGPREF N_("This panel lists all the available satellite (DVB-S/ISDB-S) frontend parameters."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'DVB-S frontend parameters'"),
"](static/img/doc/linuxdvb_frontend_dvbs/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_linuxdvb_frontend_dvbt_class[] = {
LANGPREF N_("This panel lists all the available Terrestrial (DVB-T/T2/ISDB-T/ATSC-T) frontend parameters."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'DVB-T frontend parameters'"),
"](static/img/doc/linuxdvb_frontend_dvbt/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_linuxdvb_satconf_class[] = {
LANGPREF N_("This panel lists all the available satellite (DVB-S/ISDB-S) configuration parameters."),
"\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_memoryinfo_class[] = {
LANGPREF N_("This tab displays various memory usage information useful for debugging."),
"\n\n",
LANGPREF N_("__It does not have any user configurable options.__"),
"\n",

NULL
};

const char *tvh_doc_mpegts_mux_class[] = {
LANGPREF N_("Muxes are locations at which services can be found. On traditional networks (DVB-C, -T and -S), these are carrier signals on which the individual channels are multiplexed, hence the name. However, Tvheadend also uses the term ‘mux’ to describe a source for multiple IP streams - so an IP address, in effect."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Mux List'"),
"](static/img/doc/mpegts_mux/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",
MDINCLUDE "inc/play",
"\n---\n",

NULL
};

const char *tvh_doc_mpegts_mux_sched_class[] = {
LANGPREF N_("Mux Schedulers enable Tvheadend to automatically play channels. This is useful to get EPG, services or access rights updates."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Mux Schedule Entries'"),
"](static/img/doc/mpegts_mux_sched/tab.png)\n\n---\n",

NULL
};

const char *tvh_doc_mpegts_network_class[] = {
LANGPREF N_("A network is the type of carrier for your television signals. Tvheadend supports several different types of network, notably:"),
"\n\n* [",
LANGPREF N_("Network Types"),
"](class/mpegts_network)\n  * ",
LANGPREF N_("Cable TV, delivered via a cable to your house"),
"\n    * [",
LANGPREF N_("DVB-C"),
"](class/dvb_network_dvbc) ",
LANGPREF N_("- common in most of Europe"),
"\n    * [",
LANGPREF N_("ISDB-C"),
"](class/dvb_network_isdb_c) ",
LANGPREF N_("- common in Brazil and various other countries throughout south America"),
"\n    * [",
LANGPREF N_("ATSC-C"),
"](class/dvb_network_atsc_c) ",
LANGPREF N_("- common in north and central America and parts of south Asia"),
"\n  * ",
LANGPREF N_("Satellite, any signal coming in via a dish"),
"\n    * [",
LANGPREF N_("DVB-S"),
"](class/dvb_network_dvbs) ",
LANGPREF N_("- Available worldwide"),
"\n    * [",
LANGPREF N_("ISDB-S"),
"](class/dvb_network_isdb_s) ",
LANGPREF N_("- available worldwide but common in Brazil and various other countries throughout south America"),
"\n  * ",
LANGPREF N_("Terrestrial, over-the-air broadcasts received through a traditional television aerial"),
"\n    * [",
LANGPREF N_("DVB-T"),
"](class/dvb_network_dvbt) ",
LANGPREF N_("- common in most of Europe"),
"\n    * [",
LANGPREF N_("ISDB-T"),
"](class/dvb_network_isdb_t) ",
LANGPREF N_("- common in Brazil and various other countries throughout south America"),
"\n    * [",
LANGPREF N_("ATSC-T"),
"](class/dvb_network_atsc_t) ",
LANGPREF N_("- common in north and central America"),
"\n  * ",
LANGPREF N_("IPTV - TV over the Internet via your broadband connection"),
"\n    * [",
LANGPREF N_("IPTV"),
"](class/iptv_network)\n    * [",
LANGPREF N_("IPTV Automatic Network"),
"](class/iptv_auto_network) ",
LANGPREF N_("- IPTV using a playlist as the source - __Please read _IPTV Automatic Network - Don't Probe Services_ below for important information!__"),
"   \n\n",
LANGPREF N_("Click the desired network type (above) to see all available"),
"  [",
LANGPREF N_("parameters"),
"](#items)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Networks' Tab Screenshot"),
"](static/img/doc/mpegts_network/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("The following tab specific buttons are available:"),
" \n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Force Scan"),
"__  | ",
LANGPREF N_("Force a new scan (i.e. scan all muxes for services) for the selected networks."),
"\n\n---\n\n#### ",
LANGPREF N_("Force Scanning"),
"\n\n",
LANGPREF N_("Force scanning can take some time. You may continue to use Tvheadend while a scan is in progress, but doing so will increase the time needed for it to complete. Note that the time required can vary depending on a number of factors, such as how many tuners you have available and the number of muxes on each."),
"\n\n---\n\n#### ",
LANGPREF N_("IPTV Automatic Network - Don't Probe Services"),
"\n\n",
LANGPREF N_("Tvheadend will by default probe each playlist entry for service information. Some service providers do not allow such probing & will deny (or rate limit) access, leading to scan failures."),
" \n\n",
LANGPREF N_("To create services without probing, _Service ID_ must be set (usually to 1) and the _Scan after creation_ check box un-ticked."),
" \n\n",
LANGPREF N_("Note, the above two settings are only visible with the view level set to Expert."),
"\n\n---\n",

NULL
};

const char *tvh_doc_mpegts_service_class[] = {
LANGPREF N_("Services are automatically pulled from muxes and can be mapped to Channels."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Services'"),
"](static/img/doc/mpegts_service/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n",
LANGPREF N_("The following tab specific buttons are available:"),
" \n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Map Services"),
"__  | ",
LANGPREF N_("Drop-down menu (see"),
" _",
LANGPREF N_("Map Services"),
"_  ",
LANGPREF N_("button table below)."),
" \n__",
LANGPREF N_("Maintenance"),
"__  | ",
LANGPREF N_("Drop-down menu (see"),
" _",
LANGPREF N_("Maintenance"),
"_  ",
LANGPREF N_("button table below)."),
"\n\n",
LANGPREF N_("Map Services Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Map selected services"),
"__  | ",
LANGPREF N_("Map the highlighted services within the grid."),
" \n__",
LANGPREF N_("Map all services"),
"__  | ",
LANGPREF N_("Map all available services as channels."),
" \n\n",
LANGPREF N_("Maintenance Button"),
" | ",
LANGPREF N_("Function"),
" \n----- | -----\n__",
LANGPREF N_("Remove unseen services (PAT/SDT) (7 days+)"),
"__  | ",
LANGPREF N_("Remove services marked as"),
" _",
LANGPREF N_("Missing in PAT/SDT"),
"_  ",
LANGPREF N_("for 7+ days."),
" \n__",
LANGPREF N_("Remove all unseen services"),
"__  | ",
LANGPREF N_("Remove all services not seen for 7+ days."),
" \n\n---\n\n#### ",
LANGPREF N_("Mapping Services to Channels"),
"\n\n  ",
LANGPREF N_("There are a number of methods to mapping available services, mapping uses the following dialog."),
"\n\n  ",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Service mapper dialog'"),
"](static/img/doc/service_mapper/dialog.png)\n\n##### ",
LANGPREF N_("Mapping All"),
"\n\n",
LANGPREF N_("Press the _[Map services]_ button and then _[Map all services]_ ."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Map All Services'"),
"](static/img/doc/mpegts_service/map_all.png)\n\n",
LANGPREF N_("The"),
" [",
LANGPREF N_("Map services to channels"),
"](class/service_mapper) ",
LANGPREF N_("will now be displayed with __all__ services checked - feel free to make changes. Once you're happy with the selection press the \"Map services\" button, you will then be taken to the"),
" [",
LANGPREF N_("Service Mapper"),
"](status_service_mapper) ",
LANGPREF N_("tab which will begin mapping the selected services to channels."),
" \n\n##### ",
LANGPREF N_("Mapping Selected"),
"\n\n",
LANGPREF N_("Click on the services you would like to map as channels, once you're done selecting press the \"Map services\" button and then \"Map selected services\"."),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Map selected'"),
"](static/img/doc/mpegts_service/map_selected.png)\n\n",
LANGPREF N_("The"),
" [",
LANGPREF N_("Map services to channels"),
"](class/service_mapper) ",
LANGPREF N_("dialog will now be displayed with the __selected__ services checked - feel free to make changes. Once you're happy with the selection press the \"Map services\" button, you will then be taken to the"),
"  [",
LANGPREF N_("Service Mapper"),
"](status_service_mapper) ",
LANGPREF N_("tab which will begin mapping the selected services to channels."),
" \n\n",
LANGPREF N_("__Tip__ : By default Tvheadend will only show a small selection of available services - you can increase this by using the paging selector at the bottom right of the page."),
"\n\n##### ",
LANGPREF N_("Mapping/Removing a Service to/from an Existing Channel"),
"\n\n",
LANGPREF N_("You can map/remove a service to/from an existing channel by doing the following:"),
"\n\n",
LANGPREF N_("__1)__ Find the desired service from within the services grid."),
" \n\n",
LANGPREF N_("If you have a lot of services you may want to use filtering to limit the number of grid entries."),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Service filtering'"),
"](static/img/doc/mpegts_service/map_selected.png)\n\n",
LANGPREF N_("__Tip__ : Remember to remove the filter when you're finished (untick the check box next to the \"Filters\" option)."),
" \n\n",
LANGPREF N_("__2)__ Double click on the channel field, a drop down listing of all defined channels will appear, check/uncheck the check box next to the channel you'd like to associate/disassociate the service with."),
" \n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Add service to channel example'"),
"](static/img/doc/mpegts_service/add_service.png)\n\n",
LANGPREF N_("__3)__ Press the _[Save]_ button from the menu bar, and you're done!"),
"\n\n---\n\n#### ",
LANGPREF N_("Service Information"),
"\n\n",
LANGPREF N_("Clicking the !"),
"[",
LANGPREF N_("'Information Icon'"),
"](static/icons/information.png)  ",
LANGPREF N_("information icon will display service details."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Service Information'"),
"](static/img/doc/mpegts_service/service_info.png)\n\n---\n",
MDINCLUDE "inc/play",
"\n---\n",

NULL
};

const char *tvh_doc_passwd_class[] = {
LANGPREF N_("This tab is the second part of Tvheadend's access control mechanism. It is where you set and maintain all user passwords (e.g. for streaming or DVR access)."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Configuration - Passwords tab'"),
"](static/img/doc/passwd/tab.png)\n\n---\n",
MDINCLUDE "inc/common_button_table_start",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("Example"),
"\n\n",
LANGPREF N_("This is an example of a password entry."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Add Password dialog'"),
"](static/img/doc/passwd/add.png)\n\n",
LANGPREF N_("Be aware that the username you enter here must match a username/entry in the Access Entries tab for it to apply. You may have multiple password entries for the same username if you wish."),
" \n\n---\n",

NULL
};

const char *tvh_doc_profile_class[] = {
LANGPREF N_("Stream Profiles are the settings for output formats. These are used for Live TV streaming and recordings. The profiles are assigned through the"),
" [",
LANGPREF N_("Access Entries"),
"](class/access)",
LANGPREF N_(", DVR Profiles or as parameter for HTTP Streaming."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Stream Profiles'"),
"](static/img/doc/profile/tab.png)\n\n* ",
LANGPREF N_("Types"),
"\n  * ",
LANGPREF N_("Built-in"),
"\n    * [",
LANGPREF N_("HTSP Profile"),
"](class/profile-htsp)\n    * [",
LANGPREF N_("MPEG-TS Pass-thru Profile"),
"](class/profile-mpegts)\n    * [",
LANGPREF N_("Matroska Profile"),
"](class/profile-matroska)\n  * ",
LANGPREF N_("Requires Tvheadend to be built with transcoding/ffmpeg enabled."),
"\n    * [",
LANGPREF N_("MPEG-TS/libav Profile"),
"](class/profile-libav-mpegts)\n    * [",
LANGPREF N_("Matroska/libav Profile"),
"](class/profile-libav-matroska)\n    * [",
LANGPREF N_("MP4/libav Profile"),
"](class/profile-libav-mp4)\n    * [",
LANGPREF N_("Transcode Profile"),
"](class/profile-transcode)\n\n",
LANGPREF N_("If you do not have a build of Tvheadend with transcoding enabled some of the above profiles (and their associated Help pages) will not be available."),
"\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save any changes made to the selected configuration."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Undo any changes made to the selected configuration since the last save."),
"\n__",
LANGPREF N_("Add"),
"__  | ",
LANGPREF N_("Add a new profile."),
"\n__",
LANGPREF N_("Delete"),
"__  | ",
LANGPREF N_("Delete the selected entry."),
"\n__",
LANGPREF N_("Clone"),
"__  | ",
LANGPREF N_("Clone the currently selected profile."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_satip_client_class[] = {
LANGPREF N_("This panel displays all available SAT>IP client parameters."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'SAT>IP Panel'"),
"](static/img/doc/satip_client/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_satip_frontend_class[] = {
LANGPREF N_("This panel displays all available SAT>IP DVB-T/DVB-S/DVB-C/ATSC-T/ATSC-C frontend parameters."),
"\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_satip_satconf_class[] = {
LANGPREF N_("This panel lists all the available satellite (DVB-S/ISDB-S) configuration parameters."),
"\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following buttons are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_satip_server_class[] = {
LANGPREF N_("SAT>IP Server is something like DVB network tuner. Tvheadend can forward mpegts input streams including on-the-fly descrambling to SAT>IP clients."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'SAT"),
">",
LANGPREF N_("IP Config tab'"),
"](static/img/doc/satip_server/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save all changes."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert all changes since last save."),
"\n__",
LANGPREF N_("Discover SAT"),
">",
LANGPREF N_("IP servers"),
"__  | ",
LANGPREF N_("Attempt to discover more SAT>IP servers on the network."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n\n#### ",
LANGPREF N_("How to Configure Tvheadend as a SAT"),
">",
LANGPREF N_("IP Server (Basic Guide)"),
"\n\n",
LANGPREF N_("__1. Define the RTSP Port__"),
" \n\n",
LANGPREF N_("This can be anything you like, it is recommended that you use 9983 (to avoid permission issues). Entering zero (0) in this field will disable the server."),
" \n\n",
LANGPREF N_("__2. Export the Tuners__"),
" \n\n",
LANGPREF N_("In the _Exported tuners_ section, enter the number of tuners (per delivery system) that you'd like to export. This setting lets the client know how many tuners are available for use, while you can enter any number you like here, exporting more tuners than you have can lead to scanning/tuning failures, e.g. \"No free tuner\"."),
"\n\n",
LANGPREF N_("__3. Export Your Networks__"),
"  \n\n",
LANGPREF N_("You must enter a _SAT>IP source number_ for all the"),
"  [",
LANGPREF N_("networks"),
"](class/mpegts_network) ",
LANGPREF N_("you want to export. If you don't export any, you will see the following error message (in the log)."),
"\n\n`satips: SAT>IP server announces an empty tuner list to a client <IP ADDRESS OF CLIENT> (missing network assignment)` \n\n",
LANGPREF N_("The _SAT>IP source number_ is matched through the “src” parameter requested by the SAT>IP client. Usually (and by default) this value is 1. For satellite tuners, this value determines the satellite source (dish). By specification, position 1 = DiseqC AA, 2 = DiseqC AB, 3 = DiseqC BA and 4 = DiseqC BB."),
"\n\n",
LANGPREF N_("Note that if you use a similar number for multiple networks, the first matched network containing the mux with the requested parameters will win (also applies to unknown muxes)."),
"\n\n",
LANGPREF N_("__4. Configure Your Client__"),
" \n\n",
LANGPREF N_("Hopefully (and if everything went to plan) your client should have now detected Tvheadend as a SAT>IP server. If not, restart or force it to perform a service discovery."),
"\n\n#### ",
LANGPREF N_("Custom M3U Playlist"),
"\n\n",
LANGPREF N_("You may put your custom m3u playlist which is advertised to clients in your tvheadend's configuration directory - filename _satip.m3u_ ."),
"\n\n---\n",

NULL
};

const char *tvh_doc_service_mapper_class[] = {
LANGPREF N_("The map services to channels dialog allows you to control which services are mapped. The options selected here get passed to the"),
"  [",
LANGPREF N_("Service Mapper"),
"](status_service_mapper) ",
LANGPREF N_("tab when you press the _[Map services]_ button."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Service mapper dialog'"),
"](static/img/doc/service_mapper/dialog.png)\n\n",
LANGPREF N_("See"),
" [",
LANGPREF N_("Services"),
"](class/mpegts_service) ",
LANGPREF N_("for more details on service mapping."),
"\n\n---\n\n#### ",
LANGPREF N_("Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Cancel"),
"__  | ",
LANGPREF N_("Cancel mapping and close the dialog."),
"\n__",
LANGPREF N_("Map Services"),
"__  | ",
LANGPREF N_("Map the services."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_timeshift_class[] = {
LANGPREF N_("This tab is used to configure timeshift properties."),
"\n\n",
LANGPREF N_("!"),
"[",
LANGPREF N_("'Timeshift Tab'"),
"](static/img/doc/timeshift/tab.png)\n\n---\n\n#### ",
LANGPREF N_("Menu Bar/Buttons"),
"\n\n",
LANGPREF N_("The following functions are available:"),
"\n\n",
LANGPREF N_("Button"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Save"),
"__  | ",
LANGPREF N_("Save the current configuration."),
"\n__",
LANGPREF N_("Undo"),
"__  | ",
LANGPREF N_("Revert the changes made since last save."),
"\n",
MDINCLUDE "inc/common_button_table_end",
"\n---\n",

NULL
};

const char *tvh_doc_action_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Action"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("NONE"),
"__  | ",
LANGPREF N_("No action, may be used for the logging and a comparison verification."),
"\n__",
LANGPREF N_("USE"),
"__  | ",
LANGPREF N_("Use this elementary stream."),
"\n__",
LANGPREF N_("ONE"),
"_",
LANGPREF N_("TIME"),
"__  | ",
LANGPREF N_("Use this elementary stream only one time per service type (like video, audio, subtitles) and language. The first sucessfully compared rule wins. For example, when one AC3 elementary stream is marked to be used with ‘eng’ language and another rule with the ONE"),
"_",
LANGPREF N_("TIME action was matched, the new AC3 elementary stream will not be added if the language for new AC3 elementary stream is ‘eng’. Note that the second rule might not have the language filter (column) set. For the CA filter, this rule means that the new CA elementary stream is added only if another CA is not already used."),
" \n__",
LANGPREF N_("EXCLUSIVE"),
"__  | ",
LANGPREF N_("Use only this elementary stream. No other elementary streams will be used."),
"\n__",
LANGPREF N_("EMPTY"),
"__  | ",
LANGPREF N_("Add this elementary stream only when no elementary streams are used from previous rules. It does not match the implicit USE rules which are added after the user rules."),
"\n__",
LANGPREF N_("IGNORE"),
"__  | ",
LANGPREF N_("Ignore this elementary stream. This stream is not used. Another successfully compared rule with different action may override it."),
"\n",

NULL
};

const char *tvh_doc_bouquet_mapping_options_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("Map zero-numbered channels"),
"__  | ",
LANGPREF N_("Include channels with no channel number."),
"\n__",
LANGPREF N_("Map unnamed channels"),
"__  | ",
LANGPREF N_("Include channels with no name."),
" \n__",
LANGPREF N_("Map radio channels"),
"__ ",
LANGPREF N_(":"),
" | ",
LANGPREF N_("Include radio channels."),
" \n__",
LANGPREF N_("Map encrypted services"),
"__  | ",
LANGPREF N_("Include channels even if the linked service is flagged as encrypted."),
" \n__",
LANGPREF N_("Merge same name"),
"__  | ",
LANGPREF N_("Combine channels with the same name into a single channel."),
"\n",

NULL
};

const char *tvh_doc_bouquet_tagging_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Create bouquet tag"),
"__  | ",
LANGPREF N_("Create a tag with the bouquets name and link it to all channels created by the bouquet."),
"\n__",
LANGPREF N_("Create type-based tags"),
"__  | ",
LANGPREF N_("Create a tag based on the channel type and link it to the channel."),
"\n__",
LANGPREF N_("Create provider name tags"),
"__  | ",
LANGPREF N_("Create a tag with the channel provider's name and link it to the channel."),
"\n__",
LANGPREF N_("Create network name tags"),
"__  | ",
LANGPREF N_("Create a tag with the network name and link it to all channels created by the bouquet."),
"\n",

NULL
};

const char *tvh_doc_cache_scheme_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Whenever you read or write data to the filesystems, the information is kept (cached) in memory for a while. This means that regularly-accessed files are available quickly without going back to the disc; it also means that there’s a disconnect when writing between the write request (from the application) and the actual write itself (to the disc/storage) as changes are buffered to be written in one go."),
"\n\n",
LANGPREF N_("Warning, setting an incorrect scheme can lead to crashes. If you're unsure select _System_ ."),
"\n\n",
LANGPREF N_("Scheme"),
" | ",
LANGPREF N_("Description"),
" \n----- | -----\n__",
LANGPREF N_("Unknown"),
"__  | ",
LANGPREF N_("A placeholder status, meaning that the configuration isn’t properly set."),
"\n__",
LANGPREF N_("System"),
"__  | ",
LANGPREF N_("Change nothing and rely on standard (default) system caching to behave as it normally would."),
"\n__",
LANGPREF N_("Don't keep"),
"__  | ",
LANGPREF N_("Tell the system that you’re not expecting to re-use the data soon, so don’t keep it in cache. The data will still be buffered for writing. Useful e.g. in a RAM-limited system like a Pi (given that you’re unlikely to be watching while recording, so data can be discarded now and read back from disc later)."),
"\n__",
LANGPREF N_("Sync"),
"__  | ",
LANGPREF N_("Tell the system to write the data immediately. This doesn’t affect whether or not it’s cached. Useful e.g. if you’ve a particular problem with data loss due to delayed write (such as if you get frequent transient power problems)."),
"\n__",
LANGPREF N_("Sync + Don't keep"),
"__  | ",
LANGPREF N_("A combination of last two variants above - data is written immediately and then discarded from cache."),
"\n",

NULL
};

const char *tvh_doc_change_parameters_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Allows you to control which parameters are merged. If the _Change parameters_ flag is turned on and a parameter (permission flags, all types of profiles, channel tags and ranges) for an entry is not set the parameter (value, list or range) is cleared (unset). This allows the next matching entry (if any) in the sequence to set it."),
"\n\n",
LANGPREF N_("For example, say you have a wildcard account with the theme set to Gray, and an admin account with the Blue theme. Unchecking the theme checkbox for the admin user would mean that the theme from the last matching entry (which in this case would be the wildcard account) applies instead."),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description/Properties"),
"\n----- | -----\n__",
LANGPREF N_("Rights"),
"__  | _",
LANGPREF N_("Streaming"),
"_ ",
LANGPREF N_(","),
" _",
LANGPREF N_("Web interface"),
"_ ",
LANGPREF N_(","),
" _",
LANGPREF N_("Video recorder"),
"_  ",
LANGPREF N_("(DVR),"),
" _",
LANGPREF N_("Admin"),
"_  ",
LANGPREF N_("and"),
" _",
LANGPREF N_("Anonymize HTSP access"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Channel number range"),
"__  | _",
LANGPREF N_("Minimal channel number"),
"_  ",
LANGPREF N_("and"),
" _",
LANGPREF N_("Maximal channel number"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Channel tags"),
"__  | _",
LANGPREF N_("Exclude channel tags"),
"_  ",
LANGPREF N_("and"),
" _",
LANGPREF N_("Channel tags"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("DVR configurations"),
"__  | _",
LANGPREF N_("DVR configuration profiles"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Streaming profiles"),
"__  | _",
LANGPREF N_("Streaming profiles"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Connection limits"),
"__  | _",
LANGPREF N_("Connection limit type"),
"_  ",
LANGPREF N_("and"),
" _",
LANGPREF N_("Limit connections"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Language"),
"__  | _",
LANGPREF N_("Language"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Web interface language"),
"__  | _",
LANGPREF N_("Web interface language"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Theme"),
"__  | _",
LANGPREF N_("Theme"),
"_ ",
LANGPREF N_("."),
"\n__",
LANGPREF N_("User interface level"),
"__  | _",
LANGPREF N_("User interface level"),
"_ ",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("The above table displays the _Change parameters_ option name and the fields that it applies to, as shown in add/edit dialog(s)."),
"\n",

NULL
};

const char *tvh_doc_config_channelicon_path_property[] = {
LANGPREF N_(":"),
" \n\n",
LANGPREF N_("The following placeholders are available:"),
"\n\n",
LANGPREF N_("Placeholder"),
" | ",
LANGPREF N_("Function"),
"\n----- | -----\n__",
LANGPREF N_("%C"),
"__  | ",
LANGPREF N_("The transliterated channel name in URL encoded ASCII with safe characters only -"),
" `WDR Köln :<>*?'\"` ",
LANGPREF N_("will be"),
" `WDR%20Koln%20________`\n__",
LANGPREF N_("%c"),
"__  | ",
LANGPREF N_("The transliterated channel name in URL encoded ASCII"),
"\n__",
LANGPREF N_("%U"),
"__  | ",
LANGPREF N_("UTF-8 encoded URL"),
"\n\n",
LANGPREF N_("Example: `file:///tmp/icons/%C.png` or `http://example.com/%c.png`"),
"\n\n",
LANGPREF N_("Note: The `file://` URLs are deescaped back when used, so `%20` means space for the filename for example."),
"\n\n",
LANGPREF N_("Safety note: For the channel name, the first dot characters (possible hidden files or special directories) are replaced with the underscore character. The possible directory delimiters (slash) and the special character backslash are replaced with the minus character."),
"\n",

NULL
};

const char *tvh_doc_config_channelname_scheme_property[] = {
LANGPREF N_(":"),
" \n\n",
LANGPREF N_("The _Channel icon path_ (above) must be set to generate the filenames. Also note that changing the scheme will not update existing icons, you must use the _[Reset Icons]_ button in the"),
" [",
LANGPREF N_("Channels"),
"](class/channel) ",
LANGPREF N_("tab to re-generate them."),
"\n\n",
LANGPREF N_("Scheme"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n",
LANGPREF N_("No scheme"),
" | ",
LANGPREF N_("Use service name \"as is\" to generate the filename."),
"\n",
LANGPREF N_("All lower-case"),
" | ",
LANGPREF N_("Generate lower-case filenames."),
"\n",
LANGPREF N_("Service name picons"),
" | ",
LANGPREF N_("Generate lower-case filenames using picon formatting."),
"\n",

NULL
};

const char *tvh_doc_config_picon_path_property[] = {
LANGPREF N_("This can be named however you wish, as either a local (file://) or remote (http://) location - however, remember that it’s pointing to a directory as the picon names are automatically generated from the service parameters frequency, orbital position (required), etc."),
"\n\n",
LANGPREF N_("Example: `file:///home/hts/picons`"),
"\n",

NULL
};

const char *tvh_doc_config_picon_servicetype_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("The _Picon path_ (above) must be set to generate the filenames. Also note that changing the scheme will not update existing icons, you must use the _[Reset Icons]_ button in the"),
" [",
LANGPREF N_("Channels"),
"](class/channel) ",
LANGPREF N_("tab to re-generate them."),
"\n\n",
LANGPREF N_("Scheme"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Standard"),
"__  | ",
LANGPREF N_("Choose this if your picon pack uses the standard naming scheme, e.g \"1_0_19_xxxx\"."),
"\n__",
LANGPREF N_("force service type to 1"),
"__  | ",
LANGPREF N_("Choose this if your picon pack has icons that start with \"1_0_1_xxxx\"."),
"\n",

NULL
};

const char *tvh_doc_connection_limit_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("All (Streaming plus DVR)"),
"__  | ",
LANGPREF N_("Allow access to all streaming options (including DVR functionality)."),
"\n__",
LANGPREF N_("Streaming"),
"__  | ",
LANGPREF N_("Limit access to streaming only (no DVR functionality)."),
"\n__",
LANGPREF N_("DVR"),
"__  | ",
LANGPREF N_("Limit access to DVR functionality only."),
"\n",

NULL
};

const char *tvh_doc_cron_property[] = {
LANGPREF N_(": Example : every day at 2am is : `0 2 * * *`"),
" \n```no-highlight\n# * * * * *\n# ┬ ┬ ┬ ┬ ┬\n# │ │ │ │ │\n# │ │ │ │ │\n# │ │ │ │ └───── day of week (0 - 6 or Sunday - Saturday)\n# │ │ │ └────────── month (1 - 12)\n# │ │ └─────────────── day of month (1 - 31)\n# │ └──────────────────── hour (0 - 23)\n# └───────────────────────── min (0 - 59)\n```\n\n",
LANGPREF N_("You cannot use non-standard predefined scheduling definitions for this field."),
"\n\n",
LANGPREF N_("See"),
" [",
LANGPREF N_("Wikipedia for a detailed look into Cron."),
"](https://en.wikipedia.org/wiki/Cron)\n",

NULL
};

const char *tvh_doc_duplicate_handling_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Record all"),
"__  | ",
LANGPREF N_("Record all matching events."),
"\n__",
LANGPREF N_("Record if different episode number"),
"__  | ",
LANGPREF N_("Record a matching event only if the episode number is different."),
"\n__",
LANGPREF N_("Record if different subtitle"),
"__  | ",
LANGPREF N_("Record a matching event only if the subtitle is different."),
"\n__",
LANGPREF N_("Record if different description"),
"__  | ",
LANGPREF N_("Record a matching event only if the description is different."),
"\n__",
LANGPREF N_("Record once per month"),
"__  | ",
LANGPREF N_("Record the first matching event once per month."),
" \n__",
LANGPREF N_("Record once per week"),
"__  | ",
LANGPREF N_("Record the first matching event once a week."),
"\n__",
LANGPREF N_("Record once per day"),
"__  | ",
LANGPREF N_("Record the first matching event once a day."),
"\n\n",
LANGPREF N_("_Local_ only checks for duplicates created by the same autorec rule, _All_ checks all the DVR logs for duplicates."),
"\n",

NULL
};

const char *tvh_doc_dvr_start_extra_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("For example, if a program is to start at 13:00 and you set a padding of 5 minutes, it will start recording at 12:54:30 (including a warm-up time of 30 seconds (user configurable)). Setting the padding per channel will override the padding set in the"),
" [",
LANGPREF N_("DVR Profile"),
"](class/profile)",
LANGPREF N_("."),
" \n\n",
LANGPREF N_("Be sure to check you have enough free tuners available to record all scheduled recordings if they overlap."),
"\n",

NULL
};

const char *tvh_doc_dvr_status_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Status"),
" | ",
LANGPREF N_("Description"),
" \n----- | -----\n",
LANGPREF N_("Aborted by user"),
" | ",
LANGPREF N_("The recording was interrupted by the user."),
" \n",
LANGPREF N_("File missing"),
" | ",
LANGPREF N_("The associated file(s) cannot be found on disk."),
"\n",
LANGPREF N_("Time missed"),
" | ",
LANGPREF N_("See below."),
"\n\n",
LANGPREF N_("Time missed can be caused by one (or more) of the following:"),
"\n\n* ",
LANGPREF N_("No free tuners - usually in-use by other subscription(s)."),
"\n* ",
LANGPREF N_("No tuners are enabled and/or have no network assigned."),
"\n* ",
LANGPREF N_("All available tuners failed to tune (this can indicate a signal, driver or hardware problem)."),
"\n* ",
LANGPREF N_("The underlying service for the channel is no longer available."),
"\n* ",
LANGPREF N_("Tvheadend wasn't running or crashed when a scheduled event/entry was to start."),
"\n",

NULL
};

const char *tvh_doc_dvr_stop_extra_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("This is extremely useful for those programs you think/know will overrun. Any value selected here will keep a tuner busy for longer, so be sure to check you have enough free tuners to record all scheduled recordings if they overlap. Setting the padding per channel will override the padding set in the"),
" [",
LANGPREF N_("DVR Profile"),
"](class/profile)",
LANGPREF N_("."),
"\n",

NULL
};

const char *tvh_doc_dvr_timerec_title_format_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("String"),
" | ",
LANGPREF N_("Format Result"),
"\n----- | -----\n",
LANGPREF N_("%F"),
" | ",
LANGPREF N_("The date in ISO-format (e.g. 2015-02-28)."),
"\n",
LANGPREF N_("%R"),
" | ",
LANGPREF N_("The time in 24h HH:MM format (e.g. 19:45)."),
"\n",
LANGPREF N_("%x"),
" | ",
LANGPREF N_("The date, formatted according to your locale settings."),
"\n\n",
LANGPREF N_("The escape-codes use the"),
" [",
LANGPREF N_("strftime"),
"](http://man7.org/linux/man-pages/man3/strftime.3.html) ",
LANGPREF N_("format."),
"\n",

NULL
};

const char *tvh_doc_epggrabber_priority_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Only OTA EIT and PSIP (ATSC) grabbers are enabled by default. Also note that __EPG data isn't merged__ , so be sure to give the highest priority to the grabber that provides you with the best data available."),
"\n",

NULL
};

const char *tvh_doc_network_discovery_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Disable"),
"__  | ",
LANGPREF N_("Disable mux discovery."),
"\n__",
LANGPREF N_("New muxes only"),
"__  | ",
LANGPREF N_("Discover new muxes only."),
"\n__",
LANGPREF N_("New muxes + changed muxes"),
"__  | ",
LANGPREF N_("Discover new muxes and changes to existing muxes."),
"\n",

NULL
};

const char *tvh_doc_pathname_property[] = {
LANGPREF N_(": The string allows you to manually specify the full path generation using the predefined modifiers for strftime (see `man strftime`, except `%n` and `%t`) and Tvheadend specific. Note that you may modify some of this format string setting using the GUI fields below."),
"\n\n",
LANGPREF N_("Format"),
" | ",
LANGPREF N_("Description"),
" | ",
LANGPREF N_("Example"),
"\n----- | ----- | -----\n`$t$n.$x` | ",
LANGPREF N_("Default format (title, unique number, extension)"),
" | ",
LANGPREF N_("Tennis - Wimbledon-1.mkv"),
"\n`$s` | ",
LANGPREF N_("Event subtitle name"),
" | ",
LANGPREF N_("Sport"),
"\n`$t` | ",
LANGPREF N_("Event title name"),
" | ",
LANGPREF N_("Tennis - Wimbledon"),
"\n`$e` | ",
LANGPREF N_("Event episode name"),
" | ",
LANGPREF N_("S02-E06"),
"\n`$c` | ",
LANGPREF N_("Channel name"),
" | ",
LANGPREF N_("SkySport"),
"\n`$g` | ",
LANGPREF N_("Content type"),
" | ",
LANGPREF N_("Movie : Science fiction"),
"\n`$n` | ",
LANGPREF N_("Unique number added when the file already exists"),
" | ",
LANGPREF N_("-1"),
"\n`$x` | ",
LANGPREF N_("Filename extension (from the active stream muxer"),
" | ",
LANGPREF N_("mkv"),
"\n`%F` | ",
LANGPREF N_("ISO 8601 date format"),
" | ",
LANGPREF N_("2011-03-19"),
"\n`%R` | ",
LANGPREF N_("The time in 24-hour notation"),
" | ",
LANGPREF N_("14:12"),
"\n\n",
LANGPREF N_("The format strings `$t`,`$s`,`%e`,`$c` also have delimiter variants such as `$ t` (space after the dollar character), `$-t`, `$_t`, `$.t`, `$,t`, `$;t`. In these cases, the delimiter is applied only when the substituted string is not empty."),
"\n\n",
LANGPREF N_("For $t and $s format strings, you may also limit the number of output characters using $99-t format string where 99 means the limit. As you can see, the delimiter can be also applied."),
"\n",

NULL
};

const char *tvh_doc_persistent_viewlevel_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Default"),
"__  | ",
LANGPREF N_("Use the \"Persistent user interface level\" value as set in"),
" [",
LANGPREF N_("Base Config"),
"](class/config)",
LANGPREF N_("."),
"\n__",
LANGPREF N_("No"),
"__  | ",
LANGPREF N_("Prevent the user from changing their view level and hide the view level drop-dowm from the interface."),
"\n__",
LANGPREF N_("Yes"),
"__  | ",
LANGPREF N_("Allow the user to change the interface view level."),
"\n",

NULL
};

const char *tvh_doc_postprocessor_property[] = {
LANGPREF N_(": Command to run after finishing a recording. The command will be run in background and is executed even if a recording is aborted or an error occurred. Use the %e error formatting string to check for errors, the error string is “OK” if recording finished successfully."),
"\n\n ",
LANGPREF N_("Supported format strings:"),
"\n\n",
LANGPREF N_("Format"),
" | ",
LANGPREF N_("Description"),
" | ",
LANGPREF N_("Example value"),
"\n----- | ----- | -----\n`%f` | ",
LANGPREF N_("Full path to recording"),
" | ",
LANGPREF N_("/home/user/Videos/News.mkv"),
"\n`%b` | ",
LANGPREF N_("Basename of recording"),
" | ",
LANGPREF N_("News.mkv"),
"\n`%c` | ",
LANGPREF N_("Channel name"),
" | ",
LANGPREF N_("BBC world"),
"\n`%O` | ",
LANGPREF N_("Owner of this recording"),
" | ",
LANGPREF N_("user"),
"\n`%C` | ",
LANGPREF N_("Who created this recording"),
" | ",
LANGPREF N_("user"),
"\n`%t` | ",
LANGPREF N_("Program title"),
" | ",
LANGPREF N_("News"),
"\n`%s` | ",
LANGPREF N_("Program subtitle"),
" | ",
LANGPREF N_("Afternoon"),
"\n`%p` | ",
LANGPREF N_("Program episode"),
" | ",
LANGPREF N_("S02.E07"),
"\n`%d` | ",
LANGPREF N_("Program description"),
" | ",
LANGPREF N_("News and stories…"),
"\n`%g` | ",
LANGPREF N_("Program content type"),
" | ",
LANGPREF N_("Current affairs"),
"\n`%e` | ",
LANGPREF N_("Error message"),
" | ",
LANGPREF N_("Aborted by user"),
"\n`%S` | ",
LANGPREF N_("Start time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224421200"),
"\n`%E` | ",
LANGPREF N_("Stop time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224426600"),
"\n`%r` | ",
LANGPREF N_("Number of errors during recording"),
" | ",
LANGPREF N_("0"),
"\n`%R` | ",
LANGPREF N_("Number of data errors during recording"),
" | ",
LANGPREF N_("6"),
"\n`%i` | ",
LANGPREF N_("Streams (comma separated)"),
" | ",
LANGPREF N_("H264,AC3,TELETEXT"),
"\n`%Z` | ",
LANGPREF N_("Comment"),
" | ",
LANGPREF N_("A string"),
"\n\n",
LANGPREF N_("_Example usage_"),
" \n\n",
LANGPREF N_("To use special characters (e.g. spaces), either put the string in quotes or escape the individual characters."),
"\n\n`/path/to/ffmpeg -i \"%f\" -vcodec libx264 -acodec copy \"/path/with white space/%b\"`\n",

NULL
};

const char *tvh_doc_postremove_property[] = {
LANGPREF N_(": Command to run after finishing a recording. The command will be run in background and is executed even if a recording is aborted or an error occurred. Use the %e error formatting string to check for errors, the error string is “OK” if recording finished successfully."),
"\n\n ",
LANGPREF N_("Supported format strings:"),
"\n\n",
LANGPREF N_("Format"),
" | ",
LANGPREF N_("Description"),
" | ",
LANGPREF N_("Example value"),
"\n----- | ----- | -----\n`%f` | ",
LANGPREF N_("Full path to recording"),
" | ",
LANGPREF N_("/home/user/Videos/News.mkv"),
"\n`%b` | ",
LANGPREF N_("Basename of recording"),
" | ",
LANGPREF N_("News.mkv"),
"\n`%c` | ",
LANGPREF N_("Channel name"),
" | ",
LANGPREF N_("BBC world"),
"\n`%O` | ",
LANGPREF N_("Owner of this recording"),
" | ",
LANGPREF N_("user"),
"\n`%C` | ",
LANGPREF N_("Who created this recording"),
" | ",
LANGPREF N_("user"),
"\n`%t` | ",
LANGPREF N_("Program title"),
" | ",
LANGPREF N_("News"),
"\n`%s` | ",
LANGPREF N_("Program subtitle"),
" | ",
LANGPREF N_("Afternoon"),
"\n`%p` | ",
LANGPREF N_("Program episode"),
" | ",
LANGPREF N_("S02.E07"),
"\n`%d` | ",
LANGPREF N_("Program description"),
" | ",
LANGPREF N_("News and stories…"),
"\n`%e` | ",
LANGPREF N_("Error message"),
" | ",
LANGPREF N_("Aborted by user"),
"\n`%S` | ",
LANGPREF N_("Start time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224421200"),
"\n`%E` | ",
LANGPREF N_("Stop time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224426600"),
"\n`%r` | ",
LANGPREF N_("Number of errors during recording"),
" | ",
LANGPREF N_("0"),
"\n`%R` | ",
LANGPREF N_("Number of data errors during recording"),
" | ",
LANGPREF N_("6"),
"\n`%i` | ",
LANGPREF N_("Streams (comma separated)"),
" | ",
LANGPREF N_("H264,AC3,TELETEXT"),
"\n\n",
LANGPREF N_("_Example usage_"),
" \n\n",
LANGPREF N_("To use special characters (e.g. spaces), either put the string in quotes or escape the individual characters."),
"\n\n`/usr/bin/tvh_file_removed \"%f\"`\n",

NULL
};

const char *tvh_doc_predefinedmuxlist_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("If you have _Network Discovery_ enabled, an out-of-date mux list isn't usually an issue provided that one of the muxes in the list scans successfully and has a"),
" [",
LANGPREF N_("Network Information Table (NIT)"),
"](https://en.wikipedia.org/wiki/Program-specific_information#NIT_.28network_information_specific_data.29)  ",
LANGPREF N_("available. Tvheadend will parse the NIT then the add newly discovered muxes automatically."),
"\n",

NULL
};

const char *tvh_doc_preprocessor_property[] = {
LANGPREF N_(": Command to run when a recording starts. The command will be run in background."),
"\n\n ",
LANGPREF N_("Supported format strings:"),
"\n\n",
LANGPREF N_("Format"),
" | ",
LANGPREF N_("Description"),
" | ",
LANGPREF N_("Example value"),
"\n----- | ----- | -----\n`%f` | ",
LANGPREF N_("Full path to recording"),
" | ",
LANGPREF N_("/home/user/Videos/News.mkv"),
"\n`%b` | ",
LANGPREF N_("Basename of recording"),
" | ",
LANGPREF N_("News.mkv"),
"\n`%c` | ",
LANGPREF N_("Channel name"),
" | ",
LANGPREF N_("BBC world"),
"\n`%O` | ",
LANGPREF N_("Owner of this recording"),
" | ",
LANGPREF N_("user"),
"\n`%C` | ",
LANGPREF N_("Who created this recording"),
" | ",
LANGPREF N_("user"),
"\n`%t` | ",
LANGPREF N_("Program title"),
" | ",
LANGPREF N_("News"),
"\n`%s` | ",
LANGPREF N_("Program subtitle"),
" | ",
LANGPREF N_("Afternoon"),
"\n`%p` | ",
LANGPREF N_("Program episode"),
" | ",
LANGPREF N_("S02.E07"),
"\n`%d` | ",
LANGPREF N_("Program description"),
" | ",
LANGPREF N_("News and stories…"),
"\n`%S` | ",
LANGPREF N_("Start time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224421200"),
"\n`%E` | ",
LANGPREF N_("Stop time stamp of recording, UNIX epoch"),
" | ",
LANGPREF N_("1224426600"),
"\n`%Z` | ",
LANGPREF N_("Comment"),
" | ",
LANGPREF N_("A string"),
"\n\n",
LANGPREF N_("_Example usage_"),
" \n\n",
LANGPREF N_("To use special characters (e.g. spaces), either put the string in quotes or escape the individual characters."),
"\n\n`/usr/bin/lcd_show \"%f\"`\n",

NULL
};

const char *tvh_doc_priority_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("The tuner (or network if using IPTV) with the highest priority value will be used out of preference. If the tuner is busy the next available with the highest priority value will be used."),
" \n\n",
LANGPREF N_("An example:"),
"\n\n",
LANGPREF N_("Tuner"),
" | ",
LANGPREF N_("Tuner A"),
" | ",
LANGPREF N_("Tuner B"),
" | ",
LANGPREF N_("Tuner C"),
" \n----- | ----- | ----- | -----\n",
LANGPREF N_("Priority"),
" | ",
LANGPREF N_("100"),
" | ",
LANGPREF N_("50"),
" | ",
LANGPREF N_("80"),
"\n",
LANGPREF N_("Status"),
" | ",
LANGPREF N_("BUSY"),
" | ",
LANGPREF N_("IDLE"),
" | ",
LANGPREF N_("IDLE"),
"\n\n",
LANGPREF N_("In the above table _Tuner A_ is busy so Tvheadend will have to use the next available idle tuner which in this example is _Tuner B_ and _Tuner C_ but because _Tuner C_ has the higher priority of the two Tvheadend will use that instead of _Tuner B_ . If no priority value is set for any tuners Tvheadend will use the first available idle tuner."),
"\n",

NULL
};

const char *tvh_doc_runningstate_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("EITp/f (Event Information Table present/following) is broadcast alongside EPG data, it allows broadcasters to tell DVRs/STBs when a program starts, pauses or finishes."),
" \n\n",
LANGPREF N_("It is recommended that you only enable this option if you're absolutely sure the flags are sent correctly and on time. Incorrect EITp/f flags can result in failed/broken recordings. You can set this option per"),
" [",
LANGPREF N_("channel"),
"](class/channel) ",
LANGPREF N_("or per"),
"  [",
LANGPREF N_("DVR profile"),
"](class/dvrconfig)",
LANGPREF N_(", enabling/disabling per channel overrides the DVR profile setting."),
"\n\n",
LANGPREF N_("Per Channel Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Not set"),
"__  | ",
LANGPREF N_("Use DVR profile setting."),
"\n__",
LANGPREF N_("Enabled"),
"__  | ",
LANGPREF N_("Enable running state (EITp/f) detection."),
"\n__",
LANGPREF N_("Disabled"),
"__  | ",
LANGPREF N_("Don't use running state (EITp/f) detection."),
"\n",

NULL
};

const char *tvh_doc_satip_muxhandling_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Auto"),
"__  | ",
LANGPREF N_("Keep the mux if it doesn't already exist."),
"\n__",
LANGPREF N_("Keep"),
"__  | ",
LANGPREF N_("Always keep the mux regardless of whether it exists or not."),
"\n__",
LANGPREF N_("Reject"),
"__  | ",
LANGPREF N_("Always reject."),
"\n__",
LANGPREF N_("Reject exact match"),
"__  | ",
LANGPREF N_("Always reject but allow partial match."),
"\n",

NULL
};

const char *tvh_doc_servicechecking_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Auto check enabled"),
"__  | ",
LANGPREF N_("Enable automatic service checking."),
"\n__",
LANGPREF N_("Auto check disabled"),
"__  | ",
LANGPREF N_("Disable automatic service checking."),
"\n__",
LANGPREF N_("Missing In PAT/SDT"),
"__  | ",
LANGPREF N_("The service is no longer available on this mux."),
"\n",

NULL
};

const char *tvh_doc_streaming_priority_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Streaming priority is like the _Priority_ setting (above) but only applies when streaming over HTTP or HTSP. If no streaming priority value is set (0) the _Priority_ value is used instead."),
"\n",

NULL
};

const char *tvh_doc_streaming_profile_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("The default profile and priorities can be changed in the"),
"  [",
LANGPREF N_("Stream Profiles"),
"](class/profile) ",
LANGPREF N_("tab. Note, when streaming using the HTSP Protocol e.g. Kodi (via pvr.hts) or Movian the HTSP profile will always be used."),
"\n",

NULL
};

const char *tvh_doc_themes_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Blue"),
"__  | ",
LANGPREF N_("Use the (default) blue theme."),
"\n__",
LANGPREF N_("Gray"),
"__  | ",
LANGPREF N_("Use the gray theme."),
"\n__",
LANGPREF N_("Access"),
"__  | ",
LANGPREF N_("Use the high contrast accessibility theme."),
"\n\n",
LANGPREF N_("This setting can be overridden on a per-user basis, see"),
" [",
LANGPREF N_("Access Entries"),
"](class/access)",
LANGPREF N_("."),
"\n",

NULL
};

const char *tvh_doc_viewlevel_access_entries_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Default"),
"__  | ",
LANGPREF N_("Use the default view level value as set in"),
" [",
LANGPREF N_("Base Config"),
"](class/config)",
LANGPREF N_("."),
"\n__",
LANGPREF N_("Basic"),
"__  | ",
LANGPREF N_("Display the most commonly used tabs/items."),
"\n__",
LANGPREF N_("Advanced"),
"__  | ",
LANGPREF N_("Display the more advanced tabs/items."),
"\n__",
LANGPREF N_("Expert"),
"__  | ",
LANGPREF N_("Show all tabs/items."),
"\n",

NULL
};

const char *tvh_doc_viewlevel_config_property[] = {
LANGPREF N_(":"),
"\n\n",
LANGPREF N_("Option"),
" | ",
LANGPREF N_("Description"),
"\n----- | -----\n__",
LANGPREF N_("Basic"),
"__  | ",
LANGPREF N_("Show basic settings/information."),
"\n__",
LANGPREF N_("Advanced"),
"__  | ",
LANGPREF N_("Show more advanced settings/information."),
"\n__",
LANGPREF N_("Expert"),
"__  | ",
LANGPREF N_("Show the expert (All) settings/information."),
"\n\n",
LANGPREF N_("This setting can be overridden on a per-user basis, see"),
" [",
LANGPREF N_("Access Entries"),
"](class/access)",
LANGPREF N_("."),
"\n",

NULL
};

const char *tvh_doc_wizard_channels[] = {
LANGPREF N_("You are now finished."),
"\n\n",
LANGPREF N_("You may further customize your settings by editing channel numbers, etc."),
"\n\n",
LANGPREF N_("If you confirm this dialog, the default administrator account will be removed. Please then the use credentials you defined thru this wizard."),
"\n\n",
LANGPREF N_("If you require further help, check out"),
" [",
LANGPREF N_("Tvheadend.org"),
"](http://tvheadend.org) ",
LANGPREF N_("or chat to us on"),
" [",
LANGPREF N_("IRC"),
"](https://kiwiirc.com/client/chat.freenode.net/?nick=tvhhelp|?#hts)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("Thank you for using Tvheadend (and don't forget to"),
" [",
LANGPREF N_("donate"),
"](http://tvheadend.org/projects/tvheadend/wiki/Donate)",
LANGPREF N_(")! :)"),
"\n",

NULL
};

const char *tvh_doc_wizard_channels2[] = {
LANGPREF N_("You are now finished."),
"\n\n",
LANGPREF N_("You may further customize your settings by editing channel numbers, etc."),
"\n\n",
LANGPREF N_("If you require further help, check out"),
" [",
LANGPREF N_("Tvheadend.org"),
"](http://tvheadend.org) ",
LANGPREF N_("or chat to us on"),
" [",
LANGPREF N_("IRC"),
"](https://kiwiirc.com/client/chat.freenode.net/?nick=tvhhelp|?#hts)",
LANGPREF N_("."),
"\n\n",
LANGPREF N_("Thank you for using Tvheadend (and don't forget to"),
" [",
LANGPREF N_("donate"),
"](http://tvheadend.org/projects/tvheadend/wiki/Donate)",
LANGPREF N_(")! :)"),
"\n",

NULL
};

const char *tvh_doc_wizard_hello[] = {
LANGPREF N_("Welcome to Tvheadend, your TV streaming server and video recorder. This wizard will help you get up and running fast. Let's start by configuring the basic language settings. Please select the default user interface and EPG language(s)."),
"\n\n",
LANGPREF N_("__This wizard should only be run on initial setup. Please cancel it if you're not willing to touch the current configuration, as continuing in such cases can lead to misconfiguration and not all changes made thru this wizard will take effect.__"),
" \n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("If you cannot see your preferred language in the language list and would like to help translate Tvheadend see"),
"  [",
LANGPREF N_("here"),
"](https://tvheadend.org/projects/tvheadend/wiki/Internationalization)",
LANGPREF N_("."),
" \n* ",
LANGPREF N_("If you don't enter a preferred language, US English will be used as a default."),
" \n* ",
LANGPREF N_("Not selecting the correct EPG language can result in garbled EPG text; if this happens, don't panic, as you can easily change it later."),
"\n\n",
LANGPREF N_("__The interface will reload in your chosen language (if the translation is available).__"),
"\n",

NULL
};

const char *tvh_doc_wizard_login[] = {
LANGPREF N_("Enter the access control details to secure your system. The first part of this covers the network details for address-based access to the system; for example, 192.168.1.0/24 to allow local access only to 192.168.1.x clients, or 0.0.0.0/0 or empty value for access from any system."),
"\n\n",
LANGPREF N_("This works alongside the second part, which is a familiar username/password combination, so provide these for both an administrator and regular (day-to-day) user."),
"\n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("You may enter a comma-separated list of network prefixes (IPv4/IPv6). If you were asked to enter a username and password during installation, we'd recommend not using the same details for a user here as it may cause unexpected behavior, incorrect permissions etc."),
"\n* ",
LANGPREF N_("To allow anonymous access for any account (administrative or regular user) enter an asterisk (*) in the username and password fields. ___It is not_ __ recommended that you allow anonymous access to the admin account."),
"\n* ",
LANGPREF N_("If you plan on accessing Tvheadend over the Internet, make sure you use strong credentials and ___do not allow anonymous access at all_ __ ."),
"\n",

NULL
};

const char *tvh_doc_wizard_mapping[] = {
LANGPREF N_("Map all discovered services to channels."),
"\n\n",
LANGPREF N_("In order for your frontend client(s) (such as Kodi, Movian, and similar) to see/play channels, you must first map discovered services to channels."),
"\n\n",
LANGPREF N_("If you would like Tvheadend to do this for you, check the 'Map all services' option below, but be aware that this will also map encrypted services you may not have access to."),
"\n\n",
LANGPREF N_("__You may omit this step (do not check 'Map all services') and map services to channels manually.__"),
" \n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("Many providers include undesirable services - Teleshopping, Adult Entertainment, etc; using the 'Map all services' will include these."),
"\n* ",
LANGPREF N_("You may need to enable specific EPG grabbers to receive OTA EPG data, See the _EPG Grabber Modules_ Help doc for details."),
"\n",

NULL
};

const char *tvh_doc_wizard_muxes[] = {
LANGPREF N_("Assign predefined muxes to networks. To save you from manually entering muxes, Tvheadend includes predefined mux lists. Please select a list for each network below."),
"\n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("Select the closest transmitter if using an antenna (T); if using cable (C), select your provider; if using satellite (S), the orbital position of the satellite your dish is pointing towards; or if using IPTV, enter the URL to your playlist."),
"\n* ",
LANGPREF N_("If you're unsure as to which list(s) to select you may want to look online for details about the various television reception choices available in your area."),
"\n* ",
LANGPREF N_("Networks already configured will not be shown below."),
"\n* ",
LANGPREF N_("Selecting the wrong list may cause the scan (on the next page) to fail."),
"\n",

NULL
};

const char *tvh_doc_wizard_network[] = {
LANGPREF N_("Now let's get your tuners configured. Go ahead and select a network for each of the tuners you would like to use. if you do not assign a network to a tuner it will __not__ be used."),
"\n\n",
LANGPREF N_("__Selecting the Right Network__ :"),
"\n\n",
LANGPREF N_("Many tuners are able to receive different signal types.."),
"\n\n",
LANGPREF N_("__If you receive your channels through an antenna (also known as an aerial)__ then you would select the network under the tuners with DVB-T/ATSC-T/ISDB-T in the name."),
"\n\n",
LANGPREF N_("__If you receive your channels through a satellite dish__ then you would select the network under the tuners with DVB-S/S2 in the name."),
"\n\n",
LANGPREF N_("__If you receive your channels via cable__ then you would select the network under the tuners with DVB-C/ATSC-C/ISDB-C in the name."),
"\n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("Tuners already in use will not appear below."),
"\n* ",
LANGPREF N_("If using IPTV, the playlist you enter must contain valid links to streams using codecs supported by Tvheadend."),
"\n* ",
LANGPREF N_("For devices with multiple tuners (e.g. either cable or terrestrial), be aware that many only allow you to use one tuner at a time. Selecting more than one tuner per device can thus result in unexpected behavior."),
"\n",

NULL
};

const char *tvh_doc_wizard_status[] = {
LANGPREF N_("Tvheadend is now scanning for available services. Please wait until the scan completes.."),
"\n\n",
LANGPREF N_("__Notes__ :"),
"\n\n* ",
LANGPREF N_("During scanning, the number of muxes and services shown below should increase. If this doesn't happen, check the connection(s) to your device(s).."),
"\n* ",
LANGPREF N_("The status tab (behind this wizard) will display signal information. If you notice a lot of errors or the signal strength appears low then this usually indicates a physical issue with your antenna, satellite dish or cable.."),
"\n* ",
LANGPREF N_("If you don't see any signal information at all, but the number of muxes or services is increasing anyway, the driver used by your device isn't supplying signal information to Tvheadend. In most cases this isn't an issue.."),
"\n",

NULL
};



const struct tvh_doc_page tvh_doc_markdown_pages[] = {
  { "before_begin", tvh_doc_root_before_begin },
  { "cmdline_options", tvh_doc_root_cmdline_options },
  { "configure_tvheadend", tvh_doc_root_configure_tvheadend },
  { "doc_about", tvh_doc_root_doc_about },
  { "doc_update", tvh_doc_root_doc_update },
  { "epg", tvh_doc_root_epg },
  { "faqs", tvh_doc_root_faqs },
  { "features", tvh_doc_root_features },
  { "index", tvh_doc_root_index },
  { "install_hardware", tvh_doc_root_install_hardware },
  { "install_tvheadend", tvh_doc_root_install_tvheadend },
  { "markdown_cribsheet", tvh_doc_root_markdown_cribsheet },
  { "overview", tvh_doc_root_overview },
  { "requirements", tvh_doc_root_requirements },
  { "status_connections", tvh_doc_root_status_connections },
  { "status_service_mapper", tvh_doc_root_status_service_mapper },
  { "status_stream", tvh_doc_root_status_stream },
  { "status_subscriptions", tvh_doc_root_status_subscriptions },
  { "toc", tvh_doc_root_toc },
  { "todo", tvh_doc_root_todo },
  { "tv_adapters", tvh_doc_root_tv_adapters },
  { "url", tvh_doc_root_url },
  { "webui_about", tvh_doc_root_webui_about },
  { "webui_general", tvh_doc_root_webui_general },
  { "inc/common_button_table_end", tvh_doc_root_inc_common_button_table_end },
  { "inc/common_button_table_start", tvh_doc_root_inc_common_button_table_start },
  { "inc/paging_tip", tvh_doc_root_inc_paging_tip },
  { "inc/play", tvh_doc_root_inc_play },
  { NULL, NULL },
};
